<?php $__env->startSection('content'); ?>

    
<?php
    $signup = getContent('signup.content',true)->data_values;
    $elements = getContent('signup.element',false,'',1);
?>
    <section class="pt-100 pb-100">
        <div class="container">
          <div class="row justify-content-center">
            <div class=" col-xl-12">
              <div class="account-wrapper">
                <div class="left bg_img" style="background-image: url(<?php echo e(getImage('assets/images/frontend/signup/'.$signup->background_image,'1080x700')); ?>);">
                  <div>
                    <h3 class="mb-3 text-white"><?php echo e(__($signup->instruction_title)); ?></h3>
                    <p class="text-white"><?php echo e(__($signup->instruction_details)); ?></p>
  
                    <ul class="square-list mt-4 text-white">
                        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                          <p><?php echo e(__($el->data_values->instruction)); ?></p>
                        </li>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div>
                </div>
                <div class="right">
                  <h3 class="title"><?php echo e($signup->heading); ?></h3>
                  <form action="<?php echo e(route('user.register')); ?>" method="POST" onsubmit="return submitUserForm();">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="firstname"><?php echo app('translator')->get('First Name'); ?></label>
                                <input id="firstname" type="text" class="form--control" name="firstname" placeholder="<?php echo app('translator')->get('First Name'); ?>" value="<?php echo e(old('firstname')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="lastname"><?php echo app('translator')->get('Last Name'); ?></label>
                                 <input id="lastname" type="text" class="form--control" name="lastname" placeholder="<?php echo app('translator')->get('Last Name'); ?>" value="<?php echo e(old('lastname')); ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="username"><?php echo e(__('Username')); ?></label>
                                <input id="username" type="text" class="form--control" name="username" placeholder="<?php echo app('translator')->get('Username'); ?>" value="<?php echo e(old('username')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('E-Mail Address'); ?></label>
                                <input id="email" type="email" class="form--control" placeholder="<?php echo app('translator')->get('Email Address'); ?>" name="email" value="<?php echo e(old('email')); ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group country-code">
                        <label for="mobile"><?php echo app('translator')->get('Mobile'); ?></label>
                        <div class="input-group ">
                            
                                <span class="input-group-text">
                                    <select name="country_code">
                                        <?php echo $__env->make('partials.country_code', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </select>
                                </span>
                            
                            <input type="text" name="mobile" class="form--control" placeholder="<?php echo app('translator')->get('Your Phone Number'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label><?php echo app('translator')->get('Country'); ?></label>
                        <input type="text" name="country" class="form--control" readonly>
                    </div>
                    <div class="form-group">
                        <label for="password"><?php echo app('translator')->get('Password'); ?></label>
                        <input id="password" type="password" class="form--control" placeholder="<?php echo app('translator')->get('Password'); ?>" name="password" required autocomplete="new-password">
                        <?php if($general->secure_password): ?>
                        <div class="progress mt-2">
                            <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <p class="text-danger my-1 capital"><?php echo app('translator')->get('Minimum 1 capital letter is required'); ?></p>
                        <p class="text-danger my-1 number"><?php echo app('translator')->get('Minimum 1 number is required'); ?></p>
                        <p class="text-danger my-1 special"><?php echo app('translator')->get('Minimum 1 special character is required'); ?></p>
                        <?php endif; ?>
                        
                    </div>

                    <div class="form-group">
                        <label for="password-confirm"><?php echo app('translator')->get('Confirm Password'); ?></label>
                        <input id="password-confirm" type="password" class="form--control" placeholder="<?php echo app('translator')->get('Confirm password'); ?>" name="password_confirmation" required autocomplete="new-password">
                    </div>

                    <?php echo $__env->make($activeTemplate.'partials.custom-captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="form-group mt-4">
                         <?php echo loadReCaptcha() ?>
                    </div>
                   
                    <div class="form-group">
                      <button type="submit" class="btn btn--base btn-md w-100"><?php echo app('translator')->get('Sign Up'); ?></button>
                    </div>
                    <p class="font-size--14px text-center"><?php echo app('translator')->get('Have an account?'); ?> <a class="text--base" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login here'); ?>.</a></p>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

    
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style type="text/css">
    .country-code .input-group-prepend .input-group-text{
        background: #fff !important;
    }
    .country-code select{
        border: none;
    }
    .country-code select:focus{
        border: none;
        outline: none;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
      "use strict";
      <?php if($country_code): ?>
        $(`option[data-code=<?php echo e($country_code); ?>]`).attr('selected','');
      <?php endif; ?>
        $('select[name=country_code]').change(function(){
            $('input[name=country]').val($('select[name=country_code] :selected').data('country'));
        }).change();
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span style="color:red;"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }

        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
        <?php if($general->secure_password): ?>
            $('input[name=password]').on('input',function(){
                var password = $(this).val();
                var width = 25;
                var capital = /[ABCDEFGHIJKLMNOPQRSTUVWXYZ]/;
                var capital = capital.test(password);
                if (!capital){
                    $('.capital').removeClass('d-none');
                }else{
                    width += 25;
                    $('.capital').addClass('d-none');
                }
                var number = /[123456790]/;
                var number = number.test(password);
                if (!number){
                    $('.number').removeClass('d-none');
                }else{
                    width += 25;
                    $('.number').addClass('d-none');
                }
                var special = /[`!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~]/;
                var special = special.test(password);
                if (!special){
                    $('.special').removeClass('d-none');
                }else{
                    width += 25;
                    $('.special').addClass('d-none');
                }

                if (width == 25) {
                    var bg = 'red';
                    var msg = 'Too Week'
                }else if(width == 50){
                    var msg = 'Week'
                    var bg = '#D7A612';
                }else if(width == 75){
                    var msg = 'Medium'
                    var bg = '#5210BF';
                }else if(width == 100){
                    var msg = 'Strong'
                    var bg = 'green';
                }
                $('.progress-bar').attr('style',`width:${width}%;background:${bg};`);
                $('.progress-bar').text(msg);
            });
        <?php endif; ?>

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>