<?php
    $content = getContent('contact_us.content',true)->data_values;
?>

<?php $__env->startSection('content'); ?>
<section class="pt-100 pb-100">
    <div class="container">
      <div class="row gy-4 justify-content-center pb-50">
        <div class="col-xl-6">
          <div class="map-wrapper h-100">
            <div class="maps"></div>
          </div>
        </div>
        <div class="col-xl-6">
          <div class="contact-form-wrapper">
            <h2 class="title"><?php echo app('translator')->get('Contact Us.'); ?></h2>
            <form method="POST" action="">
                <?php echo csrf_field(); ?>
              <div class="row">
                <div class="col-lg-6 form-group">
                  <label><?php echo app('translator')->get('Name'); ?></label>
                  <input type="text" name="name" placeholder="<?php echo app('translator')->get('Enter full name'); ?>" class="form--control" required value=""<?php echo e(old('name')); ?>>
                </div>
                <div class="col-lg-6 form-group">
                    <label><?php echo app('translator')->get('Email'); ?></label>
                    <input type="email" name="email" placeholder="<?php echo app('translator')->get('Enter email address'); ?>" class="form--control" required value="<?php echo e(old('email')); ?>">
                </div>
                <div class="col-lg-12 form-group">
                  <label><?php echo app('translator')->get('Subject'); ?></label>
                  <input type="text" name="subject" placeholder="<?php echo app('translator')->get('Write your subject'); ?>" class="form--control" required value=""<?php echo e(old('name')); ?>>
                </div>
        
                <div class="col-lg-12 form-group">
                  <label><?php echo app('translator')->get('Message'); ?></label>
                  <textarea placeholder="<?php echo app('translator')->get('Your message'); ?>" name="message" class="form--control" required></textarea>
                </div>
                <div class="col-lg-12">
                  <button type="submit" class="btn btn--base btn-md"><?php echo app('translator')->get('Submit Now'); ?></button>
                </div>
              </div>
            </form>
          </div><!-- contact-form-wrapper end -->
        </div>
      </div><!-- row end -->
      <h3 class="fw-bold mb-4"><?php echo e(__($content->title)); ?></h3>
      <div class="row gy-4 justify-content-center">
        <div class="col-lg-4 col-md-6">
          <div class="contact-info-card">
            <div class="contact-info-card__icon">
              <i class="las la-phone-volume"></i>
            </div>
            <div class="contact-info-card__content">
              <h4 class="title"><?php echo app('translator')->get('Mobile Number'); ?></h4>
              <a href="tel:<?php echo e($content->contact_number); ?>"><?php echo e($content->contact_number); ?></a>
            </div>
          </div><!-- contact-info-card end -->
        </div>
        <div class="col-lg-4 col-md-6">
          <div class="contact-info-card">
            <div class="contact-info-card__icon">
              <i class="las la-envelope"></i>
            </div>
            <div class="contact-info-card__content">
              <h4 class="title"><?php echo app('translator')->get('Email Address'); ?></h4>
              <a href="mailto:<?php echo e($content->email_address); ?>"><?php echo e($content->email_address); ?></a>
            </div>
          </div><!-- contact-info-card end -->
        </div>
        <div class="col-lg-4 col-md-6">
          <div class="contact-info-card">
            <div class="contact-info-card__icon">
              <i class="las la-map-marked-alt"></i>
            </div>
            <div class="contact-info-card__content">
              <h4 class="title"><?php echo app('translator')->get('Address'); ?></h4>
              <a href="javascript:void(0)"><?php echo e($content->address); ?></a>
            </div>
          </div><!-- contact-info-card end -->
        </div>
      </div><!-- row end -->
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
  <script src="https://maps.google.com/maps/api/js?key=<?php echo e($content->map_api); ?>"></script>
  <script>
    'use strict';
    var styleArray = [{
      "featureType": "all",
      "elementType": "geometry",
      "stylers": [{
        "color": "#202c3e"
      }]
    },
    {
      "featureType": "all",
      "elementType": "labels.text.fill",
      "stylers": [{
          "gamma": 0.01
        },
        {
          "lightness": 20
        },
        {
          "weight": "1.39"
        },
        {
          "color": "#ffffff"
        }
      ]
    },
    {
      "featureType": "all",
      "elementType": "labels.text.stroke",
      "stylers": [{
          "weight": "0.96"
        },
        {
          "saturation": "9"
        },
        {
          "visibility": "on"
        },
        {
          "color": "#000000"
        }
      ]
    },
    {
      "featureType": "all",
      "elementType": "labels.icon",
      "stylers": [{
        "visibility": "off"
      }]
    },
    {
      "featureType": "landscape",
      "elementType": "geometry",
      "stylers": [{
          "lightness": 30
        },
        {
          "saturation": "9"
        },
        {
          "color": "#29446b"
        }
      ]
    },
    {
      "featureType": "poi",
      "elementType": "geometry",
      "stylers": [{
        "saturation": 20
      }]
    },
    {
      "featureType": "poi.park",
      "elementType": "geometry",
      "stylers": [{
          "lightness": 20
        },
        {
          "saturation": -20
        }
      ]
    },
    {
      "featureType": "road",
      "elementType": "geometry",
      "stylers": [{
          "lightness": 10
        },
        {
          "saturation": -30
        }
      ]
    },
    {
      "featureType": "road",
      "elementType": "geometry.fill",
      "stylers": [{
        "color": "#193a55"
      }]
    },
    {
      "featureType": "road",
      "elementType": "geometry.stroke",
      "stylers": [{
          "saturation": 25
        },
        {
          "lightness": 25
        },
        {
          "weight": "0.01"
        }
      ]
    },
    {
      "featureType": "water",
      "elementType": "all",
      "stylers": [{
        "lightness": -20
      }]
    }
  ]

var lat = parseFloat('<?php echo e($content->latitude); ?>')
var long = parseFloat('<?php echo e($content->longitude); ?>')

  var mapOptions = {
    center: new google.maps.LatLng(lat,long),
    zoom: 10,
    styles: styleArray,
    scrollwheel: false,
    backgroundColor: '#e5ecff',
    mapTypeControl: false,
    mapTypeId: google.maps.MapTypeId.ROADMAP
  };
  var map = new google.maps.Map(document.getElementsByClassName("maps")[0],
    mapOptions);
  var myLatlng = new google.maps.LatLng(lat, long);
  var focusplace = {lat: 55.864237, lng: -4.251806};
  var marker = new google.maps.Marker({
    position: myLatlng,
    map: map,
    icon: {
      url: "<?php echo e(asset($activeTemplateTrue.'images/map-marker.png')); ?>"
    }
  })
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>