<?php $__env->startSection('content'); ?>

<?php
    $login = getContent('login.content',true)->data_values;
    $elements = getContent('login.element',false,'',1);
?>

<section class="pt-100 pb-100">
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-9">
              <div class="account-wrapper">
                <div class="left bg_img" style="background-image: url(<?php echo e(getImage('assets/images/frontend/login/'.$login->background_image,'1080x700')); ?>);">
                  <div>
                    <h3 class="mb-3 text-white"><?php echo e(__($login->instruction_title)); ?></h3>
                    <p class="text-white"><?php echo e(__($login->instruction_details)); ?></p>

                  <ul class="square-list mt-4 text-white">
                      <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $el): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li>
                        <p><?php echo e(__($el->data_values->instruction)); ?></p>
                      </li>
                          
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                  </ul>
                  </div>
                </div>
                <div class="right">
                  <h3 class="title"><?php echo e(__($login->heading)); ?></h3>
                  <form method="POST" action="<?php echo e(route('user.login')); ?>"
                  onsubmit="return submitUserForm();">
                  <?php echo csrf_field(); ?>
                    <div class="form-group">
                      <label><?php echo app('translator')->get('Username'); ?></label>
                      <input type="text" name="username" placeholder="<?php echo app('translator')->get('Username'); ?>" class="form--control" required value="<?php echo e(old('username')); ?>">
                    </div>
                    <div class="form-group">
                      <label><?php echo app('translator')->get('Password'); ?></label>
                      <input type="password" name="password" placeholder="<?php echo app('translator')->get('Enter password'); ?>" class="form--control" required>
                    </div>

                    <?php echo $__env->make($activeTemplate.'partials.custom-captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="form-group mt-4">
                         <?php echo loadReCaptcha() ?>
                    </div>
                   
                    <div class="form-group">
                      <button type="submit" class="btn btn--base btn-md w-100"><?php echo app('translator')->get('Login Now'); ?></button>
                    </div>
                  <div class="d-flex justify-content-between">
                    <p class="font-size--14px text-center"><?php echo app('translator')->get('Haven\'t an account?'); ?> <a class="text--base" href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Sign Up'); ?>.</a></p>
                    <p class="font-size--14px text-center"><a class="text--base" href="<?php echo e(route('user.password.request')); ?>"><?php echo app('translator')->get('Forgot Password ? '); ?>.</a></p>
                  </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span style="color:red;"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }
        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>