

<?php $__env->startSection('panel'); ?>

    <div class="row">

        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Package Name'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Price'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Validity'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Subscription Name'); ?>"><span class="text--small badge font-weight-normal badge--success"><?php echo e($package->name); ?></span></td>
                                <td data-label="<?php echo app('translator')->get('Price'); ?>"><span class="badge badge-pill bg--primary"><?php echo e($general->cur_sym); ?> <?php echo e(getAmount($package->price)); ?> <?php echo e($general->cur_text); ?></span></td>
                                <td data-label="<?php echo app('translator')->get('Validity'); ?>"><?php echo e($package->validity); ?> <?php echo app('translator')->get('days'); ?></td>
                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($package->status == 1): ?>
                                     <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('active'); ?></span>
                                    <?php else: ?>
                                     <span class="text--small badge font-weight-normal badge--warning"><?php echo app('translator')->get('inactive'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <a href="javascript:void(0)" class="icon-btn edit" data-package="<?php echo e($package); ?>" data-route="<?php echo e(route('admin.packages.update',$package->id)); ?>" data-toggle="tooltip" title="<?php echo app('translator')->get('Edit'); ?>">
                                        <i class="las la-edit text--shadow"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                 
                </div>
            </div><!-- card end -->
        </div>


    </div>

<div class="modal fade" id="addModal" tabindex="-1" role="dialog"  aria-hidden="true">
    <div class="modal-dialog" role="document">
      <form action="<?php echo e(route('admin.packages.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
            <div class="modal-header bg--primary">
              <h5 class="modal-title text-white"><?php echo app('translator')->get('Add Package'); ?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Name'); ?></label>
                    <input class="form-control" type="text" name="name" placeholder="<?php echo app('translator')->get('Package Name'); ?>" value="<?php echo e(old('name')); ?>" required>
                </div>
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Price'); ?></label>
                    <div class="input-group">
                       <input class="form-control" type="number" min="0" name="price" placeholder="<?php echo app('translator')->get('Package Price'); ?>" value="<?php echo e(old('price')); ?>" required>
                       <div class="input-group-append">
                           <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                       </div>
                    </div>
                </div>
               
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Validity'); ?> <small>(<?php echo app('translator')->get('in days'); ?>)</small></label>
                    <div class="input-group">
                       <input class="form-control" type="number" min="1" name="validity" placeholder="<?php echo app('translator')->get('Package validity'); ?>" value="<?php echo e(old('validity')); ?>" required>
                       <div class="input-group-append">
                           <span class="input-group-text"><?php echo app('translator')->get('days'); ?></span>
                       </div>
                    </div>
                </div>

                 <div class="form-group">
                     <label><?php echo app('translator')->get('Status'); ?></label>
                     <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="<?php echo app('translator')->get('active'); ?>" data-off="<?php echo app('translator')->get('inactive'); ?>" name="status">
                 </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
              <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Submit'); ?></button>
            </div>
          </div>
      </form>
    </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1" role="dialog"  aria-hidden="true">
    <div class="modal-dialog" role="document">
      <form action="" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
            <div class="modal-header bg--primary">
              <h5 class="modal-title text-white"><?php echo app('translator')->get('Edit Package'); ?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Name'); ?></label>
                    <input class="form-control" type="text" name="name" placeholder="<?php echo app('translator')->get('Package Name'); ?>" required>
                </div>
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Price'); ?></label>
                    <div class="input-group">
                       <input class="form-control" type="number" min="0" name="price" placeholder="<?php echo app('translator')->get('Package Price'); ?>" required>
                       <div class="input-group-append">
                           <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                       </div>
                    </div>
                </div>
               
                <div class="form-group">
                    <label ><?php echo app('translator')->get('Validity'); ?> <small>(<?php echo app('translator')->get('in days'); ?>)</small></label>
                    <div class="input-group">
                       <input class="form-control" type="number" min="1" name="validity" placeholder="<?php echo app('translator')->get('Package validity'); ?>" required>
                       <div class="input-group-append">
                           <span class="input-group-text"><?php echo app('translator')->get('days'); ?></span>
                       </div>
                    </div>
                </div>

                 <div class="form-group">
                     <label><?php echo app('translator')->get('Status'); ?></label>
                     <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="<?php echo app('translator')->get('active'); ?>" data-off="<?php echo app('translator')->get('inactive'); ?>" name="status">
                 </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
              <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Submit'); ?></button>
            </div>
          </div>
      </form>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>

<!-- Button trigger modal -->
<button type="button" class="btn btn--primary mr-3 mt-2" data-toggle="modal" data-target="#addModal">
  <i class="las la-plus"></i> <?php echo app('translator')->get('Add Package'); ?>
</button>

<form action="" method="GET" class="form-inline float-sm-right bg--white mt-2">
     <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('search by name'); ?>" value="<?php echo e($search??''); ?>">
          <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
          </div>
     </div>
</form>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>

    <script>
        'use strict';
        (function ($) {
            $('.edit').on('click',function () { 
                var packages = $(this).data('package')
                var price = parseInt(packages.price)
                var route = $(this).data('route')
                $('#editModal').find('input[name=name]').val(packages.name)
                $('#editModal').find('input[name=price]').val(price.toFixed(2))
                $('#editModal').find('input[name=validity]').val(packages.validity)

                if(packages.status == 1){
                    $('#editModal').find('input[name=status]').bootstrapToggle('on')
                }
                $('#editModal').find('form').attr('action',route)
                $('#editModal').modal('show')
             })
        })(jQuery);
    </script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/admin/packages.blade.php ENDPATH**/ ?>