

<?php $__env->startSection('panel'); ?>

    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Slug'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Type'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Fields'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Name'); ?>">
                                     <?php echo e($category->name); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('Slug'); ?>"><?php echo e($category->slug); ?></td>
                                <td data-label="<?php echo app('translator')->get('Type'); ?>">
                                    <?php if($category->type == 1): ?>
                                    <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('sell'); ?></span>
                                    <?php else: ?>
                                    <span class="text--small badge font-weight-normal badge--primary"><?php echo app('translator')->get('rent'); ?></span>
                                    <?php endif; ?>
                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($category->status == 1): ?>
                                    <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('active'); ?></span>
                                    <?php else: ?>
                                    <span class="text--small badge font-weight-normal badge--warning"><?php echo app('translator')->get('inactive'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Fields'); ?>"><a href="<?php echo e(route('admin.subcategories.fields',$category->id)); ?>" class="icon-btn btn--dark"> <i class="las la-eye"></i> <?php echo app('translator')->get('see'); ?></a></td>
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <a href="javascript:void(0)" data-subcategory="<?php echo e($category); ?>" data-route="<?php echo e(route('admin.subcategories.update',$category->id)); ?>" class="icon-btn edit" data-toggle="tooltip" title="<?php echo app('translator')->get('edit sub-category'); ?>">
                                        <i class="las la-edit text--shadow"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($subCategories)); ?>

                </div>
            </div><!-- card end -->
        </div>


         <!-- Add Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="<?php echo e(route('admin.subcategories.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header bg--primary">
                    <h5 class="modal-title text-white" id="exampleModalLabel"><?php echo app('translator')->get('Add Sub Category'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </div>
                        <div class="modal-body">
                            <input type="hidden" name="category_id" value="<?php echo e($cat->id); ?>">
                            <div class="form-group">
                                <label ><?php echo app('translator')->get('Name'); ?></label>
                                <input type="text" class="form-control" name="name"  placeholder="<?php echo app('translator')->get('Name'); ?>">
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Select Type'); ?>*</label>
                                <select  class="form-control type" name="type">
                                    <option value="1"><?php echo app('translator')->get('Sell'); ?></option>
                                    <option value="2"><?php echo app('translator')->get('Rent'); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-control-label font-weight-bold"><?php echo app('translator')->get('Status'); ?> </label>
                                <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="<?php echo app('translator')->get('Active'); ?>" data-off="<?php echo app('translator')->get('Inactive'); ?>" name="status">
                            </div>
                        </div>
                    <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
      
         <!-- edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header bg--primary">
                    <h5 class="modal-title text-white" id="exampleModalLabel"><?php echo app('translator')->get('Edit Sub Category'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="category_id" value="<?php echo e($cat->id); ?>">
                        <div class="form-group">
                            <label ><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control" name="name"  placeholder="<?php echo app('translator')->get('Name'); ?>">
                        </div>
                        <div class="form-group">
                            <label for="my-select"><?php echo app('translator')->get('Select Type'); ?>*</label>
                            <select id="my-select" class="form-control type" name="type">
                                <option value="1"><?php echo app('translator')->get('Sell'); ?></option>
                                <option value="2"><?php echo app('translator')->get('Rent'); ?></option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="form-control-label font-weight-bold"><?php echo app('translator')->get('Status'); ?> </label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="<?php echo app('translator')->get('Active'); ?>" data-off="<?php echo app('translator')->get('Inactive'); ?>" name="status">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
      </div>

    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>

  <a href="<?php echo e(route('admin.categories')); ?>" class="btn btn--dark mr-3 mt-2"> <i class="las la-backward"></i>
    <?php echo app('translator')->get('Go Back'); ?>
  </a>
    <!-- Button trigger modal -->
    <button type="button" class="btn btn--primary mr-3 mt-2" data-toggle="modal" data-target="#addModal">
     <i class="las la-plus"></i> <?php echo app('translator')->get('Add Sub-Category'); ?>
    </button>
    
    <form action="<?php echo e(route('admin.categories')); ?>" method="GET" class="form-inline float-sm-right bg--white mt-2">
        <div class="input-group has_append">
            <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Search by name'); ?>" value="" autocomplete="off">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            'use strict'
            $('.edit').on('click',function () { 
                var subcategory = $(this).data('subcategory')
                var route = $(this).data('route')

                $('#editModal').find('input[name=name]').val(subcategory.name)
                $('#editModal').find('select[name=type]').val(subcategory.type)
               
                $('#editModal').find('form').attr('action',route)
                if(subcategory.status == 1){
                    $('#editModal').find('input[name=status]').bootstrapToggle('on')
                }
                $('#editModal').modal('show')
                
            });
          
        })(jQuery);

    </script>

<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/admin/category/subcategories.blade.php ENDPATH**/ ?>