<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <title><?php echo e($general->sitename($page_title ?? '')); ?></title>
  <link rel="shortcut icon" type="image/png" href="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/favicon.png')); ?>">
  <!-- bootstrap 5  -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/bootstrap.min.css')); ?>">
  <!-- fontawesome 5  -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/all.min.css')); ?>"> 
  <!-- lineawesome font -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/line-awesome.min.css')); ?>"> 
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lightcase.css')); ?>"> 
  <!-- slick slider css -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/slick.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/select2.min.css')); ?>">
  <!-- main css -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom.css')); ?>">
  <link href="<?php echo e(asset($activeTemplateTrue.'css/color.php')); ?>?color=<?php echo e($general->base_color); ?>&color2=<?php echo e($general->secondary_color); ?>"rel="stylesheet" />
  <?php echo $__env->yieldPushContent('style-lib'); ?>

  <?php echo $__env->yieldPushContent('style'); ?>
</head>
  <body>
    <?php echo loadFbComment() ?>
      <!-- header-section start  -->
     <?php echo $__env->make($activeTemplate.'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
     <!-- header-section end  -->
     
     <div class="main-wrapper">

        <?php if(!request()->routeIs('home')): ?>
            <?php echo $__env->make($activeTemplate.'partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>


        <section class="pt-100 pb-100">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-3">
                <?php echo $__env->make($activeTemplate.'partials.sidemenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              </div>
              <div class="col-lg-9 ps-xl-5 mt-lg-0 mt-5">
                <?php echo $__env->yieldContent('content'); ?>
              </div>
            </div>
          </div>
        </section>


    </div><!-- main-wrapper end -->
        
<!-- footer section start-->     
    <?php echo $__env->make($activeTemplate.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
<!-- footer section end -->
    <!-- jQuery library -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/jquery-3.5.1.min.js')); ?>"></script>
  <!-- bootstrap js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/bootstrap.bundle.min.js')); ?>"></script>
  <!-- slick slider js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/slick.min.js')); ?>"></script>
  <!-- scroll animation -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/wow.min.js')); ?>"></script>
  <!-- lightcase js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/lightcase.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/select2.min.js')); ?>"></script>
  <!-- main js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/app.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/custom.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/nicEdit.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('admin.partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
      (function($,document){
          "use strict";
          bkLib.onDomLoaded(function() {
              $( ".nicEdit" ).each(function( index ) {
                  $(this).attr("id","nicEditor"+index);
                  new nicEditor({fullPanel : true}).panelInstance('nicEditor'+index,{hasPanel : true});
              });
          });
        
      })(jQuery, document);
    </script>

    <script>
        (function ($) {
            "use strict";
            $(document).on("change", ".langSel", function() {
                window.location.href = "<?php echo e(url('/')); ?>/change/"+$(this).val() ;
            });
        })(jQuery);
    </script>
  </body>
</html> <?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/layouts/master.blade.php ENDPATH**/ ?>