<?php $__env->startSection('content'); ?>
<?php
	$banner = getContent('banner.content',true)->data_values;
	$divisions = \App\Models\Division::where('status',1)->get();
?>

  <section class="hero bg_img" style="background-image: url(<?php echo e(getImage('assets/images/frontend/banner/'.$banner->background_image,'1920x1080')); ?>);">
	<div class="container">
	  <div class="row justify-content-center">
		<div class="col-xxl-6 col-lg-8 text-center">
		  <span class="hero__subtitle"><?php echo e(__($banner->title)); ?></span>
		  <h2 class="hero__title"><?php echo e(__($banner->heading)); ?></h2>
		  <p class="hero__description"><?php echo e(__($banner->sub_heading)); ?></p>
		</div>
	  </div><!-- row end -->
	  <div class="row justify-content-center mt-5">
		<div class="col-xl-8 col-lg-10">
		  <form class="hero-search-form" action="" method="GET" id="searchForm">
			<div class="input-group ps-sm-2">
			  <i class="las la-tag"></i>
			  <input type="text" name="search" placeholder="<?php echo app('translator')->get('Enter keyword, title'); ?>" autocomplete="off" class="form--control border-none" required>
			</div>
			<div class="input-group ps-sm-3">
			  <i class="las la-map-marker"></i>
			  <select class="select" name="division">
				  <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $div): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				    <option value="<?php echo e($div->slug); ?>"><?php echo e($div->name); ?></option>
				  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			  </select>
			</div>
			<button type="submit" class="hero-search-form-btn"><i class="las la-search"></i> <?php echo app('translator')->get('Search'); ?></button>
		  </form>
		  <p class="text-white font-size--16px mt-3 text-center"><?php echo e(__($banner->popular_keyword)); ?></p>
		</div>
	  </div>
	</div>
  </section>

	<?php
		$searchUrl =  http_build_query(request()->except('search'));
		$searchUrl =   str_replace("amp%3B","",$searchUrl);
		$queryStrings = json_encode(request()->query());
	?>
	<?php $__env->startPush('script'); ?>
	<script>
		'use strict';
		$('#searchForm').on('submit',function(e){
			e.preventDefault();
			var data = $(this).serialize();
			var url = '<?php echo e(url()->current()); ?>'+'/items/all'+'?<?php echo e($searchUrl); ?>';
			url = url.replaceAll('amp;','');
			var queryString = "<?php echo e($queryStrings); ?>"
			var delim;
			if(queryString.length > 2){
			delim = "&" 
			}else {
			delim = ""
			}
			window.location.href = url+delim+data;
		});
	</script>
	<?php $__env->stopPush(); ?>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate.'sections.'.$sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/home.blade.php ENDPATH**/ ?>