<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->yieldPushContent('additionalSeo'); ?>
  <title><?php echo e($general->sitename($page_title ?? '')); ?></title>
  <!-- bootstrap 5  -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/bootstrap.min.css')); ?>">
  <!-- fontawesome 5  -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/all.min.css')); ?>"> 
  <!-- lineawesome font -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/line-awesome.min.css')); ?>"> 
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lightcase.css')); ?>"> 
  <!-- slick slider css -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/slick.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/odometer.css')); ?>">
  <!-- main css -->
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom.css')); ?>">
  <link href="<?php echo e(asset($activeTemplateTrue.'css/color.php')); ?>?color=<?php echo e($general->base_color); ?>&color2=<?php echo e($general->secondary_color); ?>"rel="stylesheet" />
  <?php echo $__env->yieldPushContent('style-lib'); ?>

  <?php echo $__env->yieldPushContent('style'); ?>
</head>
  <body>
    <?php echo loadFbComment() ?>
      <!-- header-section start  -->
     <?php echo $__env->make($activeTemplate.'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
     <!-- header-section end  -->
     
     <div class="main-wrapper">

        <?php if(!request()->routeIs('home')): ?>
            <?php echo $__env->make($activeTemplate.'partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

         <?php echo $__env->yieldContent('content'); ?>
    </div><!-- main-wrapper end -->
        




<?php
    $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first();
?>


<?php if(@$cookie->data_values->status && !session('cookie_accepted')): ?>
    <div class="cookie-remove">
        <div class="cookie__wrapper">
            <div class="container">
            <div class="d-flex flex-wrap align-items-center justify-content-between">
                <p class="txt my-2">
                    <?php echo @$cookie->data_values->description ?><br>
                <a href="<?php echo e(@$cookie->data_values->link); ?>" target="_blank" class="text--base mt-2"><?php echo app('translator')->get('Read Policy'); ?></a>
                </p>
                <button class="btn btn-md btn--base d-lg-inline-flex align-items-center my-2 policy cookie"><?php echo app('translator')->get('Accept'); ?></button>
            </div>
            </div>
        </div>
    </div>
<?php endif; ?>




<!-- footer section start-->     
    <?php echo $__env->make($activeTemplate.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
<!-- footer section end -->
    <!-- jQuery library -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/jquery-3.5.1.min.js')); ?>"></script>
  <!-- bootstrap js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/bootstrap.bundle.min.js')); ?>"></script>
  <!-- slick slider js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/slick.min.js')); ?>"></script>
  <!-- scroll animation -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/wow.min.js')); ?>"></script>
  <!-- lightcase js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/lightcase.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/select2.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/viewport.jquery.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lib/odometer.min.js')); ?>"></script>
  <!-- main js -->
  <script src="<?php echo e(asset($activeTemplateTrue.'js/app.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/custom.js')); ?>"></script>


<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('admin.partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>
        (function ($) {
            "use strict";
            $(document).on("change", ".langSel", function() {
                window.location.href = "<?php echo e(url('/')); ?>/change/"+$(this).val() ;
            });


            $('.cookie').on('click',function () {

            var url = "<?php echo e(route('cookie.accept')); ?>";

            $.get(url,function(response){

                if(response.success){
                   notify('success',response.success);
                   $('.cookie-remove').html('');
                }
            });

        });


        })(jQuery);
    </script>
    
        
  </body>
</html> <?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/layouts/frontend.blade.php ENDPATH**/ ?>