

<?php $__env->startSection('panel'); ?>

    <div class="row">

        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Title'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('User'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Reported at'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Reasons'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                            if($report->seen == 0){
                                $report->seen = 1;
                                $report->update();
                            }
                            ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Title'); ?>">
                                    <div class="user">
                                        <div class="thumb"><img src="<?php echo e(getImage('assets/images/item_image/'.$report->ad->prev_image,'100x100')); ?>" alt="image"></div>
                                        <span class="name"><a target="_blank" href="<?php echo e(route('ad.details',$report->ad->slug)); ?>"><?php echo e($report->ad->title); ?></a></span>
                                    </div>
                                </td>
                                <td data-label="<?php echo app('translator')->get('User'); ?>"><a href="<?php echo e(route('admin.users.detail',$report->user->id)); ?>"><?php echo e($report->user->username); ?></a></td>
                               
                                <td data-label="<?php echo app('translator')->get('Reported at'); ?>"><?php echo e(showDateTime($report->created_at,'d M Y')); ?></td>

                                <td data-label="<?php echo app('translator')->get('Reasons'); ?>">
                                    <button type="button" class="btn btn-sm btn--dark seeReason" data-toggle="modal" data-target="#reasonModal" data-reasons="<?php echo e($report->reasons); ?>"> <i class="las la-eye"></i><?php echo app('translator')->get('see'); ?></button>

                                </td>
                               
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <a href="javascript:void(0)" data-route="<?php echo e(route('admin.ads.status',$report->id)); ?>" class="icon-btn btn--dark unpublish" data-toggle="tooltip" title="<?php echo app('translator')->get('Unpublish'); ?>">
                                        <i class="las la-undo"></i>
                                    </a>
                                  
                                   
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($reports)); ?>

                </div>
            </div><!-- card end -->
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="reasonModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg--primary">
                    <h5 class="modal-title text-white"><?php echo app('translator')->get('Reasons'); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                   <p class="reasons"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                  
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
            <button type="button" class="close ml-auto m-3" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body text-center">
                        
                        <i class="las la-exclamation-circle text--danger display-2 mb-15"></i>
                        <h4 class="text--secondary mb-15"><?php echo app('translator')->get('Are you sure want to unpublish this?'); ?></h4>

                    </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit"  class="btn btn--danger del"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
                
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    
<form action="" method="GET" class="form-inline float-sm-right bg--white">
    <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Ad title'); ?>" value="<?php echo e($search??''); ?>">
        <div class="input-group-append">
            <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>

<script>

    'use strict';
     $('.seeReason').on('click',function () { 
        $('.reasons').text($(this).data('reasons'))
     })

     $('.unpublish').on('click',function(){
        var route = $(this).data('route')
        var modal = $('#confirmModal');
        modal.find('form').attr('action',route)
        modal.modal('show');
    })

</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/admin/ads/reports.blade.php ENDPATH**/ ?>