<?php
    $content = getContent('location.content',true)->data_values;
    $locations = \App\Models\Division::where('status',1)->take(8)->inRandomOrder()->get();
?>


   <!-- location section start -->
   <section class="pt-25 pb-50">
    <div class="container">
      <div class="row">
        <div class="col-lg-6">
          <div class="section-header">
            <h2 class="section-title"><?php echo e(__($content->heading)); ?></h2>
          </div>
        </div>
      </div><!-- row end -->
      <div class="row gy-4 justify-content-center">
        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-3 col-md-4 col-sm-6">
          <div class="location-card">
            <img src="<?php echo e(getImage('assets/images/location/'.$location->image,'300x220')); ?>" alt="image">
            <div class="overlay-content has--link">
              <a href="<?php echo e(route('ads')); ?><?php echo e(queryBuild('division',$location->slug)); ?>" class="item--link"></a>
              <h3 class="title"><?php echo e(__($location->name)); ?></h3>
              <span class="location-amount"><?php echo e(getAmount($location->totalAd())); ?></span>
            </div>
          </div><!-- location-card 
		  end -->
        </div>
       
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </section>
  <!-- location section end -->



<?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/sections/location.blade.php ENDPATH**/ ?>