<?php
    $user = auth()->user();
?>
<div class="account-sidebar">
  <button type="button" class="account-sidebar-open-btn"><i class="las la-bars"></i><?php echo app('translator')->get(' Dashboard Menu'); ?></button>
      <?php if(url()->current() == url('user/dashboard')): ?>
      <div class="account-header mb-3">
        <div class="thumb">
          <img src="<?php echo e(getImage('assets/images/user/profile/'.$user->image,'400x400')); ?>" alt="image">
        </div>
        <div class="content">
          <h6 class="name fw-bold"><?php echo e($user->fullname); ?></h4>
          <ul class="account-info-list mt-3">
            <li>
              <i class="las la-map-marked-alt"></i>
              <span><?php echo e($user->address->address ?? 'No address'); ?></span>
            </li>
            <li>
              <i class="las la-phone-volume"></i>
              <span><?php echo e($user->mobile); ?></span>
            </li>
            <li>
              <i class="las la-envelope"></i>
              <span><?php echo e($user->email); ?></span>
            </li>
          </ul>
        </div>
      </div>
      <?php endif; ?>
    
    <div class="account-menu-wrapper mt-0">
      <button type="button" class="account-sidebar-close-btn"><i class="las la-times"></i></button>

      <ul class="account-menu">
        <li class="menu-header mt-0"><?php echo app('translator')->get('Ads Menu'); ?></li>

        <li class="<?php echo e(menuActive('user.home')); ?>">
            <a href="<?php echo e(route('user.home')); ?>">
              <i class="las la-sliders-h"></i>
              <span class="menu-title"><?php echo app('translator')->get('Dashboard'); ?></span>
            </a>
          </li>

          <li class="<?php echo e(menuActive('user.post.ad')); ?>">
            <a href="<?php echo e(route('user.post.ad')); ?>">
              <i class="las la-folder-plus"></i>
              <span class="menu-title"><?php echo app('translator')->get('Post An Ad'); ?></span>
            </a>
          </li>

        <li class="<?php echo e(menuActive('user.ad.list')); ?>">
          <a href="<?php echo e(route('user.ad.list')); ?>">
            <i class="las la-list-alt"></i>
            <span class="menu-title"><?php echo app('translator')->get('Active Ads'); ?></span>
          </a>
        </li>
        <li class="<?php echo e(menuActive('user.saved.ads')); ?>">
          <a href="<?php echo e(route('user.saved.ads')); ?>">
            <i class="las la-bookmark"></i>
            <span class="menu-title"><?php echo app('translator')->get('Saved Ads'); ?></span>
          </a>
        </li>
        
        <li class="<?php echo e(menuActive('user.ad.promotion.log')); ?>">
          <a href="<?php echo e(route('user.ad.promotion.log')); ?>">
            <i class="las la-bullhorn"></i>
            <span class="menu-title"><?php echo app('translator')->get('Promotion Log'); ?></span>
          </a>
        </li>
       
        <li class="<?php echo e(menuActive('user.deposit.history')); ?>">
          <a href="<?php echo e(route('user.deposit.history')); ?>">
            <i class="las la-wallet"></i>
            <span class="menu-title"><?php echo app('translator')->get('Payment Log'); ?></span>
          </a>
        </li>
        <li class="<?php echo e(menuActive('user.trx.history')); ?>">
          <a href="<?php echo e(route('user.trx.history')); ?>">
            <i class="las la-exchange-alt"></i>
            <span class="menu-title"><?php echo app('translator')->get('Transaction Log'); ?></span>
          </a>
        </li>
        


        <li class="menu-header"><?php echo app('translator')->get('User Menu'); ?></li>
        
        <li  class="<?php echo e(menuActive('user.profile-setting')); ?>">
          <a href="<?php echo e(route('user.profile-setting')); ?>">
            <i class="las la-user"></i>
            <span><?php echo app('translator')->get('Profile Setting'); ?></span>
          </a>
        </li>
        <li class="<?php echo e(menuActive('user.change-password')); ?>">
          <a href="<?php echo e(route('user.change-password')); ?>">
            <i class="las la-lock"></i>
            <span class="menu-title"><?php echo app('translator')->get('Change Password'); ?></span>
          </a>
        </li>
        <li class="<?php echo e(menuActive('user.twofactor')); ?>">
          <a href="<?php echo e(route('user.twofactor')); ?>">
            <i class="las la-key"></i>
            <span class="menu-title"><?php echo app('translator')->get('2FA Security'); ?></span>
          </a>
        </li>
        <li class="<?php echo e(menuActive('ticket')); ?>">
          <a href="<?php echo e(route('ticket')); ?>">
            <i class="las la-ticket-alt"></i>
            <span class="menu-title"><?php echo app('translator')->get('Support Ticket'); ?></span>
          </a>
        </li>
      </ul>
    </div>
  
  </div><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/templates/basic/partials/sidemenu.blade.php ENDPATH**/ ?>