

<?php $__env->startSection('panel'); ?>

    <div class="row">

        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Ad Title'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Username'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Package Name/Validity'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Payment Gateway'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('State'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Ad Title'); ?>">
                                    <div class="user">
                                        <div class="thumb"><img src="<?php echo e(getImage('assets/images/item_image/'.$request->ad->prev_image,'100x100')); ?>" alt="image"></div>
                                        <span class="name"><a class="text-secondary" data-toggle="tooltip" title="<?php echo e($request->ad->title); ?>" target="_blank" href="<?php echo e(route('ad.details',$request->ad->slug)); ?>"><?php echo e(Str::limit($request->ad->title,25)); ?></a></span>
                                    </div>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Username'); ?>"><a href="<?php echo e(route('admin.users.detail',$request->user->id)); ?>"><?php echo e($request->user->username); ?></a></td>
                                <td data-label="<?php echo app('translator')->get('Package Name/Validity'); ?>">
                                    <span class="font-weight-bold text--warning"><?php echo e($request->package->name); ?></span> <br>
                                    <span class="text--primary"><?php echo e($request->package->validity); ?> <?php echo app('translator')->get('days'); ?></span>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>"><span class="text--small badge font-weight-normal badge--success"><?php echo e(getAmount($request->package->price)); ?> <?php echo e($general->cur_text); ?></span></td>
                                <td data-label="<?php echo app('translator')->get('Payment Gateway'); ?>"><?php echo e($request->gateway ? $request->gateway->name : 'from refunded balace'); ?></td>

                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($request->status == 1): ?>
                                     <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('Accepted'); ?></span>
                                    <?php elseif($request->status == 0): ?>
                                    <span class="text--small badge font-weight-normal badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                                    <?php else: ?> 
                                    <span class="text--small badge font-weight-normal badge--danger"><?php echo app('translator')->get('Rejected'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($request->running == 1): ?>
                                     <span class="text--small badge font-weight-normal badge--primary"><?php echo app('translator')->get('Running'); ?></span>
                                    <?php else: ?> 
                                    <span class="text--small badge font-weight-normal badge--dark"><?php echo app('translator')->get('Not Running'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <?php if($request->status == 0): ?>
                                    <a href="javascript:void(0)" data-route="<?php echo e(route('admin.ad.promote.accept',$request->id)); ?>" class="icon-btn mr-2 confirm" data-toggle="tooltip" title="<?php echo app('translator')->get('accept'); ?>">
                                        <i class="las la-check-double text--shadow"></i>
                                    </a>

                                    <a href="javascript:void(0)" data-route="<?php echo e(route('admin.ad.promote.reject',$request->id)); ?>" data-amount="<?php echo e(getAmount($request->package->price)); ?>" class="icon-btn btn--danger rejectBtn" data-toggle="tooltip" title="<?php echo app('translator')->get('reject'); ?>">
                                        <i class="las la-ban text--shadow"></i>
                                    </a>
                                   
                                    <?php else: ?>
                                        <?php echo app('translator')->get('N/A'); ?>
                                    <?php endif; ?>
                                    
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($requests)); ?>

                </div>
            </div><!-- card end -->
        </div>


        <div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header bg--primary">
                        <h5 class="modal-title text-white"><?php echo app('translator')->get('Reject Ad Promotion Confirmation'); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="modal-body">
                            <p><?php echo app('translator')->get('Are you sure want to'); ?> <span class="font-weight-bold"><?php echo app('translator')->get('reject ?'); ?></span></p>
                            
                            <p><span class="amount font-weight-bold text--success"> </span> <?php echo app('translator')->get(' will be refunded to user refund balance'); ?></p>

                            <div class="form-group">
                                <label class="font-weight-bold mt-2"><?php echo app('translator')->get('Reason for Rejection'); ?></label>
                                <textarea name="message" id="message" placeholder="<?php echo app('translator')->get('Reason for Rejection'); ?>" class="form-control" rows="5"></textarea>
                            </div>
    
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                            <button type="submit" class="btn btn--danger"><?php echo app('translator')->get('Reject'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
            <button type="button" class="close ml-auto m-3" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body text-center">
                        
                        <i class="las la-exclamation-circle text--success display-2 mb-15"></i>
                        <h4 class="text--secondary mb-15"><?php echo app('translator')->get('Are you sure want to accept?'); ?></h4>

                    </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('close'); ?></button>
                    <button type="submit"  class="btn btn--success del"><?php echo app('translator')->get('Accept'); ?></button>
                </div>
                
                </form>
            </div>
        </div>
    </div>

    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>

<form action="" method="GET" class="form-inline float-sm-right bg--white">
    <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Search by ad title'); ?>" value="<?php echo e($search??''); ?>" autocomplete="off">
        <div class="input-group-append">
            <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    
<script>
    'use strict';
    $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            var curr = '<?php echo e($general->cur_text); ?>'
            modal.find('.amount').text($(this).data('amount')+' '+curr);
            modal.find('form').attr('action',$(this).data('route'))
            modal.modal('show');
    });

    $('.confirm').on('click',function(){
        var route = $(this).data('route')
        var modal = $('#confirmModal');
        modal.find('form').attr('action',route)
        modal.modal('show');
    })
</script>
   
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/serv5info/public_html/adsnew/core/resources/views/admin/promotion/all.blade.php ENDPATH**/ ?>