<!DOCTYPE html>
<!--[if IE 8]>
<html <?php language_attributes(); ?> class="ie8"> <![endif]-->
<!--[if !IE]><!-->
<html <?php language_attributes(); ?>> <!--<![endif]-->

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <title><?php wp_title( '|', true, 'right' ); ?><?php bloginfo( 'name' ); ?></title>
    <meta name="description" content="<?php bloginfo( 'description' ); ?>">

    <!-- Mobile Specific Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->


	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<header <?php if(!is_home() & is_single() || is_page() || is_category() || is_search()): ?> class="custom-header"<?php endif; ?>>


    <div class="container">
        <section class="contacts-bar-top">
            <div class="row">
                <div class="col-md-3">
                    <a href="<?php echo home_url(); ?>"><img src="<?php echo IMAGES; ?>/logo-small.png" class="img-responsive logo center" alt="<?php bloginfo('name'); ?>"></a>
                </div>
                <div class="col-md-9 ">
                    <br>
                    <ul class="list-inline text-left ">

						<?php if ( get_field( 'phone', 'options' ) ) : ?>
                            <li><i class="fa fa-phone-square"></i> <?php the_field( 'phone', 'options' ); ?></li>
						<?php endif; ?>
						<?php if ( get_field( 'email', 'options' ) ) : ?>
                            <li><i class="fa fa-send"></i> <?php the_field( 'email', 'options' ); ?>
                            </li>
						<?php endif; ?>
						<?php if ( get_field( 'address', 'options' ) ) : ?>
                            <li><i class="fa fa-map-marker"></i> <?php the_field( 'address', 'options' ); ?>
                            </li>
						<?php endif; ?>

                    </ul>
                    <br>
                    <br>
                    <ul class="list-inline top-social">
                        <li class="search-icon"><a href="" data-toggle="modal" data-target="#myModal" ><i class="fa fa-search"></i></a>
                        </li>
						<?php if ( get_field( 'fb', 'options' ) ) : ?>
                            <li><a href="<?php the_field( 'fb', 'options' ); ?>"><i
                                            class="fa fa-facebook"></i></a></li>
						<?php endif; ?>
						<?php if ( get_field( 'tw', 'options' ) ) : ?>
                            <li><a href="<?php the_field( 'tw', 'options' ); ?>"><i
                                            class="fa fa-twitter"></i></a></li>
						<?php endif; ?>
						<?php if ( get_field( 'yt', 'options' ) ) : ?>
                            <li><a href="<?php the_field( 'yt', 'options' ); ?>"><i
                                            class="fa fa-youtube"></i></a></li>
						<?php endif; ?>
						<?php if ( get_field( 'gp', 'options' ) ) : ?>
                            <li><a href="<?php the_field( 'gp', 'options' ); ?>"><i
                                            class="fa fa-google-plus"></i></a></li>
						<?php endif; ?>
						<?php if ( get_field( 'inst', 'options' ) ) : ?>
                            <li><a href="<?php the_field( 'inst', 'options' ); ?>"><i
                                            class="fa fa-instagram"></i></a>
                            </li>
						<?php endif; ?>

                    </ul>
                </div>

            </div>


        </section>

    </div>

</header>



<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><?php _e( 'بحث', 'alpha' ); ?></h4>
            </div>
            <div class="modal-body">
				<?php get_search_form(); ?>
            </div>

        </div>
    </div>
</div>




<?php wp_reset_query(); ?>