<?php require_once ('header-custom.php'); ?>


<div class="menu-wrapper">


    <div class="container">

        <nav class="navbar navbar-default">
            <div class="container-fluid">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                            data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
				<?php
				wp_nav_menu( array(
						'menu'            => 'main',
						'theme_location'  => 'main',
						'depth'           => 2,
						'container'       => 'div',
						'container_class' => 'collapse navbar-collapse',
						'container_id'    => 'bs-example-navbar-collapse-1',
						'menu_class'      => 'nav navbar-nav',
						'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
						'walker'          => new wp_bootstrap_navwalker()
					)
				);
				?>
            </div><!-- /.container-fluid -->
        </nav>


    </div>
</div>
<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
    <div class="container">
		<?php if ( function_exists( 'bcn_display' ) ) {
			bcn_display();
		} ?>
    </div>
</div>
<div class="container">
	<div class="box-section">
		<div class="box-section-title">
			<h1><?php printf( __( 'نتائج البحث لـ  %s', 'alpha' ), get_search_query() ); ?></h1>
		</div>

	</div>
</div>
<br><br>
<div class="container">

	<div class="page-content">
		<div class="row">
			<?php if ( have_posts() ) : ?>
				<?php while ( have_posts() ) :
					the_post(); ?>
					<div class="col-md-3 col-sm-6">
						<div class="single-search">
							<a href="<?php the_permalink(); ?>">
								<?php if ( get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ) ): ?>
									<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
								<?php else : ?>
									<img src="<?php echo IMAGES; ?>/no-img.png" alt="<?php the_title(); ?>"
									     class="img-responsive">
								<?php endif; ?>
								<p><?php echo mb_substr(get_the_title(),0,100)?></p>
							</a>
						</div>
					</div>
				<?php endwhile; ?>
			<?php else : ?>

				<div class="center">
					<h4><?php _e('لا يوجد نتائج للبحث حاول مرة أخري بكلمات مختلفة','alpha'); ?></h4>


					<?php get_search_form(); ?>
				</div>
			<?php endif; ?>
			<br><br><br>
		</div>
	</div>

</div>

<br><br><br>

<?php get_footer(); ?>


