<?php require_once ('header-custom.php'); ?>


<div class="menu-wrapper">


    <div class="container">

        <nav class="navbar navbar-default">
            <div class="container-fluid">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                            data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
				<?php
				wp_nav_menu( array(
						'menu'            => 'main',
						'theme_location'  => 'main',
						'depth'           => 2,
						'container'       => 'div',
						'container_class' => 'collapse navbar-collapse',
						'container_id'    => 'bs-example-navbar-collapse-1',
						'menu_class'      => 'nav navbar-nav',
						'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
						'walker'          => new wp_bootstrap_navwalker()
					)
				);
				?>
            </div><!-- /.container-fluid -->
        </nav>


    </div>
</div>
<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
    <div class="container">
		<?php if ( function_exists( 'bcn_display' ) ) {
			bcn_display();
		} ?>
    </div>
</div>
<br><br><br><br><br>
<div class="container">
    <div class="row">
        <div class="col-md-8">
            <div class="news-boxed-img">
				<?php

				if ( get_field( 'video-link' ) ) :

					$string = get_field( 'video-link' );
					$search = '#(.*?)(?:href="https?://)?(?:www\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch?.*?v=))([\w\-]{10,12}).*#x';
					$replace = 'http://www.youtube.com/embed/$2';
					$url = preg_replace( $search, $replace, $string );; ?>
                    <iframe width="100%" height="500" src="<?php echo $url; ?>" frameborder="0"
                            allowfullscreen></iframe>
				<?php elseif ( $images = get_field( 'gallery' ) ) : ?>


                    <div id="carousel-example-generic" class="carousel slide"
                         data-ride="carousel">


                        <!-- Wrapper for slides -->
                        <div class="carousel-inner">
							<?php foreach ( $images as $image ): ?>
                                <div class="item">
                                    <a href="<?php echo $image['url']; ?>" rel="lightbox">
                                        <img src="<?php echo $image['url']; ?>"
                                             alt="<?php echo $image['alt']; ?>"/>
                                    </a>

                                </div>

							<?php endforeach; ?>


                        </div>

                        <!-- Controls -->
                        <a class="left carousel-control" href="#carousel-example-generic"
                           role="button"
                           data-slide="prev">
                            <span class="glyphicon glyphicon-chevron-left"></span>
                        </a>
                        <a class="right carousel-control" href="#carousel-example-generic"
                           role="button"
                           data-slide="next">
                            <span class="glyphicon glyphicon-chevron-right"></span>
                        </a>
                    </div>

				<?php else   : ?>
                    <a href="<?php the_permalink(); ?>">
						<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>

                    </a>
                    <a href="<?php the_permalink(); ?>">

                    </a>

				<?php endif; ?>


            </div>
            <section class="news-sections cat-sec">
                <div class="row">
                    <div class="col-md-12">

                        <div class="box-section ">


                            <div id="page-content">

                                <div class="the_title">
                                    <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                </div>
                                <div class="the_cats">
									<?php the_category(); ?>
                                </div>
                                <div class="share">
									<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) {
										ADDTOANY_SHARE_SAVE_KIT();
									} ?>

                                </div>
                                <?php if(have_rows('prices')) : ?>
                                <div class="prices">
                                    <h3>أسعار المشاوير لهذه السيارة</h3>
									<?php while ( have_rows( 'prices' ) ) : the_row(); ?>
                                        <p>
                                            من :
											<b><?php the_sub_field( 'from' ) ?></b>
                                            الي :
											<b><?php the_sub_field( 'to' ) ?></b>
                                            ( <strong><?php the_sub_field('price'); ?></strong> )

                                        </p>
									<?php endwhile; ?>
                                </div>
                                <?php endif; ?>
								<?php the_content(); ?>

								<?php

								$images = get_field( 'gallery' );

								if ( $images ): ?>
                                    <h3 class="gallery-title"><?php _e( 'البوم الصور الخاص بهذه السيارة :', 'alpha' ); ?></h3>
                                    <ul class="list-inline" id="list-imgs">
										<?php foreach ( $images as $image ): ?>
                                            <li>
                                                <a href="<?php echo $image['url']; ?>" rel="lightbox">
                                                    <img src="<?php echo $image['sizes']['thumbnail']; ?>"
                                                         alt="<?php echo $image['alt']; ?>"/>
                                                </a>
                                            </li>
										<?php endforeach; ?>
                                    </ul>
								<?php endif; ?>
                                <br>
                                <div class="tags">
                                    <p><?php the_tags(); ?></p>
                                </div>
                                <br>


                            </div>

                        </div>


                    </div>

                </div>

            </section>
            <div class="related-posts hidden-xs">
                <h3 class="related-posts-title">سيارات أخري قد تعجبك</h3>
                <ul class="list-inline text-center">
					<?php $related = new WP_Query( array(
						'post_type'      => 'cars',
						'posts_per_page' => 4,
						'post__not_in'   => array( $post->ID )
					) ); ?>
					<?php while ( $related->have_posts() )  : $related->the_post(); ?>
                        <li class="single-related-post">

                            <a href="<?php the_permalink(); ?>">
								<?php $thumb = get_the_post_thumbnail( $post->id, 'large', array( 'class' => 'img-responsive' ) );

								if ( $thumb ) : echo $thumb;
								else : ?>
                                    <img src="<?php echo IMAGES; ?>/no-img.png" alt="" class="img-responsive">

								<?php endif; ?>
                                <h2><?php the_title(); ?></h2>
                            </a>

                        </li>
					<?php endwhile;
					wp_reset_query(); ?>
                </ul>

            </div>


            <div class="related-posts">
                <h3 class="related-posts-title">تعليقات</h3>
				<?php comments_template(); ?>

            </div>


        </div>
        <div class="col-md-4 hidden-xs hidden-sm">
            <div class="sidebar-cat">
                <section class="news-sections">
                    <div class="box-section">
						<?php get_sidebar( 'sidebar' ); ?>

                    </div>


                </section>


            </div>
        </div>
    </div>

</div>


<br><br><br><br>

<?php get_footer(); ?>


