<?php
get_header();
wp_reset_query(); ?>

    <div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
        <div class="container">
            <?php if (function_exists('bcn_display')) {
                bcn_display();
            } ?>
        </div>
    </div>

<section class="tags-page-posts">
    <div class="container">
        <div class="center">
            <h2 class="sec-title"><?php printf(__('Tag Archives: %s', 'twentyfourteen'), single_tag_title('', false)); ?></h2>
        </div>
        <br><br><br>
        <div class="row">
            <?php while (have_posts()) : the_post(); ?>
                <div class="col-md-4 col-sm-6">
                    <div <?php post_class('single-blog-post'); ?> >
                        <div class="ImageWrapper">
                            <?php
                            if (get_the_post_thumbnail()) :
                                echo get_the_post_thumbnail($post->id, 'full', array('class' => 'img-responsive'));
                            else : ?>
                                <img src="<?php echo IMAGES; ?>/no-img.png" alt="<?php the_title(); ?> "
                                     class="img-responsive">
                            <?php endif; ?>
                            <div class="ImageOverlayS"></div>
                            <div class="StyleH">
							<span class="hover-icon"><a href="<?php the_permalink(); ?>"
                                                        title="<?php the_title(); ?>"><i class="fa fa-search-plus"></i></a></span>
                            </div>
                        </div>
                        <div class="post-text">
                            <p>
                                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </p>
                        </div>
                        <div class="post-meta">
                            <span class="date"><?php echo get_the_date($post->id); ?></span>
                            <span class="comments"><a><i class="fa fa-comment"></i>(<?php comments_number(); ?>)</a></span>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>


<?php

get_footer();
