<?php get_header();
wp_reset_query(); ?>
<br><br>
<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
	<div class="container">
		<?php if ( function_exists( 'bcn_display' ) ) {
			bcn_display();
		} ?>
	</div>
</div>

<div class="container">
	<div class="row">
		<?php while ( have_posts() ) :
			the_post(); ?>
			<?php if ( get_field( 'video-url' ) ) : ?>
			<div class="col-md-4 col-sm-6">
				<div class="single-video">
					<div class="video-container">
						<?php

						$string  = get_field( 'video-url' );
						$search  = '#(.*?)(?:href="https?://)?(?:www\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch?.*?v=))([\w\-]{10,12}).*#x';
						$replace = 'http://www.youtube.com/embed/$2';
						$url     = preg_replace( $search, $replace, $string );; ?>
						<iframe width="100%" height="300" src="<?php echo $url; ?>" frameborder="0"
						        allowfullscreen></iframe>

					</div>
					<div class="caption">
						<p><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</p>

					</div>
				</div>
			</div>

		<?php else : ?>
			<div class="col-md-3 col-sm-6">
				<div class="single-album">
					<div class="back">
						<a href="<?php the_permalink(); ?>">
							<i class="fa fa-search-plus"></i>
							<p><?php _e( 'مشاهدة', 'alpha' ); ?></p>
						</a>
					</div>
					<?php if ( get_the_post_thumbnail( $post->id ) ) : ?>
						<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) );
					elseif
					( $images = get_field( 'gallery' )
					) :
						$img0 = $images[0] ?>
						<a href="<?php echo $img0['url']; ?>" rel="lightbox[all]">
							<img src="<?php echo $img0['url'] ?>"
							     alt="<?php echo $img0['alt']; ?>" class="img-responsive"/>
						</a>
					<?php else : ?>
						<img src="<?php echo IMAGES; ?>/no-img.png" alt="">
					<?php endif; ?>
				</div>
				<p class="album-title"><?php the_title(); ?></p>
			</div>
		<?php endif; ?>

		<?php endwhile; ?>
	</div>
	<br><br><br><br>
</div>
<section class="socialmedia">
	<div class="container">
		<ul class="list-inline text-center">
			<?php if(get_field('fb','options')) : ?>
				<li><a href="<?php the_field('fb','options'); ?>"><i class="fa fa-facebook"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('tw','options')) : ?>
				<li><a href="<?php the_field('tw','options'); ?>"><i class="fa fa-twitter"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('yt','options')) : ?>
				<li><a href="<?php the_field('yt','options'); ?>"><i class="fa fa-youtube"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('gp','options')) : ?>
				<li><a href="<?php the_field('gp','options'); ?>"><i class="fa fa-google-plus"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('insta','options')) : ?>
				<li><a href="<?php the_field('insta','options'); ?>"><i class="fa fa-instagram"></i></a></li>
			<?php endif; ?>
		</ul>
	</div>
</section>
<?php get_footer(); ?>
