<?php
/**
 * functions.php
 *
 * The theme's functions and definitions.
 */

/**
 * ----------------------------------------------------------------------------------------
 * 1.0 - Define constants.
 * ----------------------------------------------------------------------------------------
 */
define( 'THEMEROOT', get_stylesheet_directory_uri() );
define( 'IMAGES', THEMEROOT . '/images' );
define( 'SCRIPTS', THEMEROOT . '/js' );
require_once( 'wp_bootstrap_navwalker.php' );


/**
 * ----------------------------------------------------------------------------------------
 * 4.0 - Set up theme default and register various supported features.
 * ----------------------------------------------------------------------------------------
 */

if ( ! function_exists( 'alpha_setup' ) ) {
	function alpha_setup() {
		/**
		 * Make the theme available for translation.
		 */
		$lang_dir = THEMEROOT . '/languages';
		load_theme_textdomain( 'alpha', $lang_dir );

		/**
		 * Add support for post formats.
		 */
//		add_theme_support( 'post-formats',
//			array(
//				'gallery',
//				'link',
//				'image',
//				'quote',
//				'video',
//				'audio'
//			)
//		);

		/**
		 * Add support for automatic feed links.
		 */
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'widgets' );

		/**
		 * Add support for post thumbnails.
		 */
		add_theme_support( 'post-thumbnails' );


		/**
		 * Register nav menus.
		 */
		register_nav_menus(
			array(
				'main-menu' => __( 'القائمة الرئيسية', 'alpha' ),
				'footer'   => __( 'قائمة الفوتر ', 'alpha' )
			)
		);
	}

	add_action( 'after_setup_theme', 'alpha_setup' );
}


/**
 * ----------------------------------------------------------------------------------------
 * 10.0 - Load the custom scripts for the theme.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'alpha_scripts' ) ) {
	function alpha_scripts() {
		// Adds support for pages with threaded comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Register scripts
		wp_register_script( 'bootstrap-js', SCRIPTS . '/bootstrap.min.js', array( 'jquery' ), false, true );
		wp_register_script( 'classie', SCRIPTS . '/classie.js', array( 'jquery' ), false, true );
//		wp_register_script( 'hoverdir', SCRIPTS . '/jquery.hoverdir.js', array( 'jquery' ), false, true );
//		wp_register_script( 'modernizr', SCRIPTS . '/modernizr.custom.97074.js', array( 'jquery' ), false, true );
		wp_register_script( 'owlcarousel', SCRIPTS . '/owl.carousel.min.js', array( 'jquery' ), false, true );
		wp_register_script( 'wow', SCRIPTS . '/wow.min.js', array( 'jquery' ), false, true );


		// Load the custom scripts
		wp_enqueue_script( 'bootstrap-js' );
		wp_enqueue_script( 'classie' );
//		wp_enqueue_script( 'hoverdir' );
//		wp_enqueue_script( 'modernizr' );
		wp_enqueue_script( 'owlcarousel' );
		wp_enqueue_script( 'wow' );
		if ( ! is_rtl() ) {
			wp_register_script( 'custom-en', SCRIPTS . '/custom-en.js', array( 'jquery' ), false, true );
			wp_enqueue_script( 'custom-en' );

		} else {
			wp_register_script( 'custom', SCRIPTS . '/custom.js', array( 'jquery' ), false, true );
			wp_enqueue_script( 'custom' );

		}
		// Load the stylesheets
		wp_enqueue_style( 'bootstrap', THEMEROOT . '/css/bootstrap.min.css' );
		wp_enqueue_style( 'Fontawesome', THEMEROOT . '/css/font-awesome.min.css' );
		wp_enqueue_style( 'animate', THEMEROOT . '/css/animate.css' );
		wp_enqueue_style( 'owl.carousel', THEMEROOT . '/css/owl.carousel.css' );
//		wp_enqueue_style( 'sinister', THEMEROOT . '/css/sinister.css' );

		if ( is_rtl() ) {

			wp_enqueue_style( 'bootstrap-rtl', THEMEROOT . '/css/bootstrap-rtl.min.css' );
			wp_enqueue_style( 'rtl', THEMEROOT . '/style.css' );

		} else {
			wp_enqueue_style( 'en', THEMEROOT . '/en.css' );
		}

	}

	add_action( 'wp_enqueue_scripts', 'alpha_scripts' );
}


/**
 * ----------------------------------------------------------------------------------------
 * 11.0 - Custom Post Type.
 * ----------------------------------------------------------------------------------------
 */


register_post_type( 'library', array(
	'public'              => true,
	'hierarchical'        => false,
	'exclude_from_search' => false,
	'has_archive'         => false,
	'rewrite'             => array( 'slug' => 'library' ),
	'capability_type'     => 'post',
	'taxonomies'          => array( 'post_tag' ),
	'labels'              => array(
		'name'               => 'المكتبة',
		'add_new_item'       => 'إضافة ',
		'singular_name'      => 'المكتبة',
		'menu_name'          => 'المكتبة',
		'name_admin_bar'     => 'المكتبة',
		'all_items'          => 'الكل',
		'add_new'            => 'إضافة ',
		'edit_item'          => 'تحرير ',
		'new_item'           => ' جديد',
		'view_item'          => 'مشاهدة ',
		'search_items'       => 'البحث ',
		'not_found'          => 'لا يوجد .',
		'not_found_in_trash' => 'لا يوجد ',
		'parent_item_colon'  => 'القسم الرئيسى'
	),
	'supports'            => array( 'title', 'thumbnail', 'editor' )
) );
/*************************************************/
/* Register Taxonami */
/*************************************************/
add_action( 'init', 'create_sections' );

function create_sections() {
	register_taxonomy(
		'sections',
		'library',
		array(
			'label'             => __( 'تصنيفات المكتبة' ),
			'hierarchical'      => true,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_nav_menus' => true,
			'show_tagcloud'     => true,
			'public'            => true
		)

	);

}
register_taxonomy(
	'sections-tags',
	'library',
	array(
		'hierarchical'  => false,
		'label'         => __( 'Tags'),
		'singular_name' => __( 'Tag' ),
		'rewrite'       => true,
		'query_var'     => true
	)
);
register_post_type( 'slider', array(
	'public'              => true,
	'hierarchical'        => false,
	'exclude_from_search' => false,
	'has_archive'         => false,
	'rewrite'             => array( 'slug' => 'slider' ),
	'capability_type'     => 'post',
	'taxonomies'          => array( 'post_tag' ),
	'labels'              => array(
		'name'               => 'السلايدر',
		'add_new_item'       => 'إضافة سلايدر',
		'singular_name'      => 'السلايدر',
		'menu_name'          => 'السلايدر',
		'name_admin_bar'     => 'سلايدر',
		'all_items'          => 'كافة السلايدر',
		'add_new'            => 'إضافة سلايدر',
		'edit_item'          => 'تحرير السلايدر',
		'new_item'           => 'سلايدر جديدة',
		'view_item'          => 'مشاهدة السلايدر',
		'search_items'       => 'البحث عن سلايدر',
		'not_found'          => 'لا يوجد سلايدرات.',
		'not_found_in_trash' => 'لا يوجد سلايدرات',
		'parent_item_colon'  => 'القسم الرئيسى'
	),
	'supports'            => array( 'title', 'thumbnail', 'editor' )
) );


add_image_size( 'small', 100, 100 );


/*************************************************/
/* Page Option */
/*************************************************/
if ( function_exists( 'acf_add_options_page' ) ) {

	acf_add_options_page( array(
		'page_title'    => 'اعدادات القالب',
		'menu_title'    => 'اعدادات القالب',
		'menu_slug'     => 'theme-general-settings',
		'capability'    => 'edit_posts',
		'update_button' => 'حفظ الاعدادات',
		'redirect'      => false
	) );


}

function mytheme_admin_bar_render() {
	global $wp_admin_bar;
	$wp_admin_bar->add_menu( array(
		'id'    => 'themeoptions',
		'title' => '<i class="options-icon"></i>' . __( 'اعدادات القالب', 'some-textdomain' ),
		'href'  => admin_url( 'admin.php?page=theme-general-settings' )
	) );
}

// and we hook our function via
add_action( 'wp_before_admin_bar_render', 'mytheme_admin_bar_render' );



