<!DOCTYPE html>
<!--[if IE 8]>
<html <?php language_attributes(); ?> class="ie8"> <![endif]-->
<!--[if !IE]><!-->
<html <?php language_attributes(); ?>> <!--<![endif]-->

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<title><?php wp_title( '|', true, 'right' ); ?><?php bloginfo( 'name' ); ?></title>
	<meta name="description" content="<?php bloginfo( 'description' ); ?>">

	<!-- Mobile Specific Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

	<!--[if lt IE 9]>
	<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->


	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header>
	<div class="top-nav">
		<div class="container">
			<div class="row">
				<div class="col-md-4">
					<div class="header-contacts">
						<ul class="list-inline">
							<?php if(is_rtl()) : ?>
								<li><a href="<?php echo home_url(); ?>/en" class="language">EN</a></li>
							<?php else : ?>
								<li><a href="<?php echo site_url(); ?>" class="language">AR</a></li>
							<?php endif; ?>
							<li><i class="fa fa-phone"></i> <?php the_field('phone','options'); ?></li>

						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<div class="logo">
						<a href="<?php echo home_url(); ?>"><img src="<?php the_field('logo','options'); ?>" alt="<?php bloginfo('description'); ?>" class="img-responsive"></a>
					</div>
				</div>
				<div class="col-md-4">
					<div class="social">
						<ul class="list-inline">
							<?php if(get_field('fb','options')) : ?>
								<li><a href="<?php the_field('fb','options'); ?>"><i class="fa fa-facebook"></i></a></li>
							<?php endif; ?>
							<?php if(get_field('tw','options')) : ?>
								<li><a href="<?php the_field('tw','options'); ?>"><i class="fa fa-twitter"></i></a></li>
							<?php endif; ?>
							<?php if(get_field('yt','options')) : ?>
								<li><a href="<?php the_field('yt','options'); ?>"><i class="fa fa-youtube"></i></a></li>
							<?php endif; ?>
							<?php if(get_field('gp','options')) : ?>
								<li><a href="<?php the_field('gp','options'); ?>"><i class="fa fa-google-plus"></i></a></li>
							<?php endif; ?>
							<?php if(get_field('insta','options')) : ?>
								<li><a href="<?php the_field('insta','options'); ?>"><i class="fa fa-instagram"></i></a></li>
							<?php endif; ?>
						</ul>
					</div>
				</div>

			</div>
		</div>
	</div>
	<div class="container">
		<nav class="navbar navbar-default">
			<!-- Brand and toggle get grouped for better mobile display -->
			<div class="navbar-header">
				<button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
				        data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
					<span class="sr-only">Toggle navigation</span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
			</div>

			<!-- Collect the nav links, forms, and other content for toggling -->
			<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
				<?php
				wp_nav_menu( array(
						'menu'              => 'main-menu',
						'theme_location'    => 'main-menu',
						'depth'             => 2,
						'menu_class'        => 'nav navbar-nav',
						'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
						'walker'            => new wp_bootstrap_navwalker())
				);
				?>


			</div><!-- /.navbar-collapse -->
		</nav>
	</div><!-- /.container-fluid -->


</header>







