<?php get_header(); ?>

<?php require_once( 'slider.php' ); ?>


<section class="welcome">
	<div class="container">
		<div class="row">
			<div class="col-md-4">
				<div class="welcome-text">
					<h1><?php the_field( 'welcome-1', 'options' ); ?></h1>
					<h2><?php the_field( 'welcome-2', 'options' ); ?></h2>
				</div>
			</div>
			<div class="col-md-8">
				<p><?php the_field( 'welcome-p', 'options' ); ?></p>
			</div>
		</div>
	</div>
</section>
<section class="library">
	<div class="container">
		<div class="center">
			<h3 class="sec-title"><?php the_field( 'books-h', 'options' ); ?></h3>
			<p class="sec-p"><?php the_field( 'books-p', 'options' ); ?></p>
		</div>
		<br><br><br><br>
		<div class="row">
			<?php
			$args  = array(
				'post_type'      => 'library',
				'posts_per_page' => 4

			);
			$books = new WP_Query( $args ); ?>


			<?php while ( $books->have_posts() ) : $books->the_post(); ?>

				<div class="col-md-3 col-sm-6">
					<div class="single-book">
						<div class="book-img">
							<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
							<a href="<?php the_permalink(); ?>">
								<div class="back">
									<h3><?php the_title(); ?></h3>
									<?php the_excerpt(); ?>
								</div>
							</a>
						</div>
						<?php if ( get_field( 'ex-url' ) ) : ?>
							<a href="<?php the_field( 'ex-url' ); ?>" class="btn btn-default btn-block"> <i
									class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
						<?php else : ?>
							<a href="<?php the_field( 'up-book' ); ?>" class="btn btn-default btn-block"> <i
									class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
						<?php endif; ?>
					</div>

				</div>

			<?php endwhile;
			wp_reset_query(); ?>

		</div>
	</div>
</section>

<section class="gallery">
	<div class="container">
		<div class="row">
			<div class="col-md-6">
				<div class="videos">
					<div class="center">
						<h1 class="sec-title"><?php the_field( 'vid-title', 'options' ); ?> </h1>
					</div>
					<div class="videos">
						<?php $vid = get_field( 'video-section', 'options' ); ?>

						<?php $vids = new WP_Query( array(
							'post_type'      => 'post',
							'posts_per_page' => 1,
							'tax_query'      => array(
								array(
									'taxonomy' => 'category',
									'field'    => 'term_id',
									'terms'    => $vid,
								)
							)
						) ); ?>
						<?php while ( $vids->have_posts() ) : $vids->the_post(); ?>
							<div class="single-video">
								<div class="video-container">
									<?php

									$string  = get_field( 'video-url' );
									$search  = '#(.*?)(?:href="https?://)?(?:www\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch?.*?v=))([\w\-]{10,12}).*#x';
									$replace = 'http://www.youtube.com/embed/$2';
									$url     = preg_replace( $search, $replace, $string );; ?>
									<iframe width="100%" height="300" src="<?php echo $url; ?>" frameborder="0"
									        allowfullscreen></iframe>

								</div>

							</div>
						<?php endwhile; ?>
					</div>
				</div>
			</div>

			<div class="col-md-6">
				<div class="photos">
					<div class="center">
						<h1 class="sec-title"><?php the_field( 'album-title', 'options' ); ?></h1>
					</div>

					<div class="row">
						<?php $album = get_field( 'albums-section', 'options' ); ?>

						<?php $albums = new WP_Query( array(
							'post_type'      => 'post',
							'posts_per_page' => 6,
							'tax_query'      => array(
								array(
									'taxonomy' => 'category',
									'field'    => 'term_id',
									'terms'    => $album,
								)
							)
						) ); ?>
						<?php while ( $albums->have_posts() ) :
						$albums->the_post(); ?>
						<div class="col-sm-4">
							<div class="single-album">
								<div class="back">
									<a href="<?php the_permalink(); ?>">
										<i class="fa fa-search-plus"></i>
										<p><?php _e( 'مشاهدة', 'alpha' ); ?></p>
									</a>
								</div>
								<?php if ( get_the_post_thumbnail( $post->id ) ) : ?>
									<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) );
								elseif
								( $images = get_field( 'gallery' )
								) :
									$img0 = $images[0] ?>
									<a href="<?php echo $img0['url']; ?>" rel="lightbox[all]">
										<img src="<?php echo $img0['url'] ?>"
										     alt="<?php echo $img0['alt']; ?>" class="img-responsive"/>
									</a>
								<?php else : ?>
								<img src="<?php echo IMAGES; ?>/no-img.png" alt="">
								<?php endif; ?>
							</div>
							<p class="album-title"><?php the_title(); ?></p>

						</div>
						<?php endwhile; ?>

					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="socialmedia">
	<div class="container">
		<ul class="list-inline text-center">
			<?php if(get_field('fb','options')) : ?>
				<li><a href="<?php the_field('fb','options'); ?>"><i class="fa fa-facebook"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('tw','options')) : ?>
				<li><a href="<?php the_field('tw','options'); ?>"><i class="fa fa-twitter"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('yt','options')) : ?>
				<li><a href="<?php the_field('yt','options'); ?>"><i class="fa fa-youtube"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('gp','options')) : ?>
				<li><a href="<?php the_field('gp','options'); ?>"><i class="fa fa-google-plus"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('insta','options')) : ?>
				<li><a href="<?php the_field('insta','options'); ?>"><i class="fa fa-instagram"></i></a></li>
			<?php endif; ?>
		</ul>
	</div>
</section>
<?php get_footer(); ?>


