<?php get_header();
wp_reset_query(); ?>
<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
	<div class="container">
		<?php if ( function_exists( 'bcn_display' ) ) {
			bcn_display();
		} ?>
	</div>
</div>
<br>


<section class="product-container">
	<div class="container">
		<div class="the-product">
			<div class="row">
				<div class="col-md-3">
					<div class="product-gallery">
						<div class="main-img">

								<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
						</div>

						<hr>
						<?php if ( get_field( 'ex-url' ) ) : ?>
							<a href="<?php the_field( 'ex-url' ); ?>" class="btn btn-default btn-block"> <i
									class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
						<?php else : ?>
							<a href="<?php the_field( 'up-book' ); ?>" class="btn btn-default btn-block"> <i
									class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
						<?php endif; ?>
						<br>
						<div class="center">
							<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) { ADDTOANY_SHARE_SAVE_KIT(); } ?>

						</div>
					</div>
				</div>
				<div class="col-md-9">
					<div class="product-info">
						<h1 class="title"><?php the_title(); ?></h1>

						<p class="desc"><?php the_content(); ?></p>


					</div>
				</div>
			</div>
		</div>
	</div>
	<br>
	<br>
	<br>
	<section class="library">
		<div class="container">
			<div class="center">
				<h3 class="sec-title"><?php _e('كتب أخري تهمك','alpha'); ?></h3>

			</div>
			<br><br><br><br>
			<div class="row">
				<?php
				$args  = array(
					'post_type'      => 'library',
					'posts_per_page' => 4

				);
				$books = new WP_Query( $args ); ?>


				<?php while ( $books->have_posts() ) : $books->the_post(); ?>

					<div class="col-md-3">
						<div class="single-book">
							<div class="book-img">
								<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
								<a href="<?php the_permalink(); ?>">
									<div class="back">
										<h3><?php the_title(); ?></h3>
										<?php the_excerpt(); ?>
									</div>
								</a>
							</div>
							<?php if ( get_field( 'ex-url' ) ) : ?>
								<a href="<?php the_field( 'ex-url' ); ?>" class="btn btn-default btn-block"> <i
										class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
							<?php else : ?>
								<a href="<?php the_field( 'up-book' ); ?>" class="btn btn-default btn-block"> <i
										class="fa fa-file-pdf-o"></i> <?php _e( 'تحميل الملف', 'alpha' ); ?></a>
							<?php endif; ?>
						</div>
					</div>
				<?php endwhile;
				wp_reset_query(); ?>

			</div>
		</div>
	</section>

</section>
<section class="socialmedia">
	<div class="container">
		<ul class="list-inline text-center">
			<?php if(get_field('fb','options')) : ?>
				<li><a href="<?php the_field('fb','options'); ?>"><i class="fa fa-facebook"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('tw','options')) : ?>
				<li><a href="<?php the_field('tw','options'); ?>"><i class="fa fa-twitter"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('yt','options')) : ?>
				<li><a href="<?php the_field('yt','options'); ?>"><i class="fa fa-youtube"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('gp','options')) : ?>
				<li><a href="<?php the_field('gp','options'); ?>"><i class="fa fa-google-plus"></i></a></li>
			<?php endif; ?>
			<?php if(get_field('insta','options')) : ?>
				<li><a href="<?php the_field('insta','options'); ?>"><i class="fa fa-instagram"></i></a></li>
			<?php endif; ?>
		</ul>
	</div>
</section>
<?php get_footer(); ?>



