<?php get_header();
wp_reset_query(); ?>

<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
	<div class="container">
		<?php if ( function_exists( 'bcn_display' ) ) {
			bcn_display();
		} ?>
	</div>
</div>
<div class="container">
	<div class="row">
		<div class="col-md-8">
			<section class="news-one-section no-bg" id="single-title-head">
				<div class="box-section">
					<div class="box-section-title">
						<h1><?php the_title() ?></h1>
					</div>
				</div>
			</section>
			<section class="news-sections cat-sec">
				<div class="row">
					<div class="col-md-12">
						<div class="box-section ">
							<div class="clearfix"></div>

							<div class="news-boxed-img">
								<?php

								if ( get_field( 'video-url' ) ) :

									$string = get_field( 'video-url' );
									$search = '#(.*?)(?:href="https?://)?(?:www\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch?.*?v=))([\w\-]{10,12}).*#x';
									$replace = 'http://www.youtube.com/embed/$2';
									$url = preg_replace( $search, $replace, $string );; ?>
									<iframe width="100%" height="500" src="<?php echo $url; ?>" frameborder="0"
									        allowfullscreen></iframe>
								<?php elseif ( $images = get_field( 'gallery' ) ) : ?>


									<div id="carousel-example-generic" class="carousel slide"
									     data-ride="carousel">


										<!-- Wrapper for slides -->
										<div class="carousel-inner">
											<?php foreach ( $images as $image ): ?>
												<div class="item">
													<a href="<?php echo $image['url']; ?>" rel="lightbox">
														<img src="<?php echo $image['url']; ?>"
														     alt="<?php echo $image['alt']; ?>"/>
													</a>

												</div>

											<?php endforeach; ?>


										</div>

										<!-- Controls -->
										<a class="left carousel-control" href="#carousel-example-generic"
										   role="button"
										   data-slide="prev">
											<span class="glyphicon glyphicon-chevron-left"></span>
										</a>
										<a class="right carousel-control" href="#carousel-example-generic"
										   role="button"
										   data-slide="next">
											<span class="glyphicon glyphicon-chevron-right"></span>
										</a>
									</div>

								<?php else   : ?>
									<a href="<?php the_permalink(); ?>">
										<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>

									</a>
									<a href="<?php the_permalink(); ?>">

									</a>

								<?php endif; ?>

							</div>

							<div id="page-content">
								<div id="post-meta">
									<span><i class="fa fa-calendar"></i> <?php echo get_the_date( $post->id ); ?></span>
									<!--									<span><i class="fa fa-clock-o"></i> -->
									<?php //echo get_the_time($post->id); ?><!--</span>-->
									<span><i class="fa fa-book"></i> <?php the_category( ', ' ); ?></span>
									<span><i
											class="fa fa-eye"></i> <?php if ( function_exists( 'the_views' ) ) {
											the_views();
										} ?></span>
									<span><i
											class="fa fa-comment"></i><?php comments_number() ?></span>
									<?php if ( is_user_logged_in() && is_super_admin() ) : ?>
										<span><a
												href="<?php echo get_edit_post_link(); ?>"><b>تحرير</b></a></span>
									<?php endif; ?>
								</div>

								<?php the_content(); ?>

								<?php

								$images = get_field( 'gallery' );

								if ( $images ): ?>
									<h3 class="gallery-title"><?php _e('البوم الصور الخاص بهذا المقال :','alpha'); ?></h3>
									<ul class="list-inline" id="list-imgs">
										<?php foreach ( $images as $image ): ?>
											<li>
												<a href="<?php echo $image['url']; ?>" rel="lightbox">
													<img src="<?php echo $image['sizes']['small']; ?>"
													     alt="<?php echo $image['alt']; ?>"/>
												</a>
											</li>
										<?php endforeach; ?>
									</ul>
								<?php endif; ?>

								<div class="share">
									<span><strong><?php _e('شارك هذا المقال :','alpha'); ?></strong></span>
									<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) {
										ADDTOANY_SHARE_SAVE_KIT();
									} ?>

								</div>
								<?php comments_template(); ?>
							</div>

						</div>


					</div>
				</div>
			</section>


		</div>
		<div class="col-md-4">
			<div class="sidebar-cat">
				<section class="news-sections">
					<div class="box-section">
						<div class="box-section-title">
							<h1>آخر المقالات</h1>
						</div>
						<div class="clearfix"></div>

					</div>

					<div class="rest-of-news" style="background: #fff;padding: 10px;margin-top: -20px;">

						<?php $box4 = new WP_Query( array(
							'post_type'      => 'post',
							'posts_per_page' => 10
						) ); ?>
						<div class="row">
							<?php while ( $box4->have_posts() ) :
								$box4->the_post(); ?>
								<div class="col-sm-12">
									<div class="single-rest">
										<a href="<?php the_permalink(); ?>">
											<div class="row">
												<div class="col-xs-3">
													<?php if ( get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ) ): ?>
														<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
													<?php else : ?>
														<img src="<?php echo IMAGES; ?>/no-img.png"
														     alt="<?php the_title(); ?>"
														     class="img-responsive">
													<?php endif; ?>
												</div>
												<div class="col-xs-9">
													<h5><?php echo wp_trim_words(get_the_title(),6) ?></h5>
												<p>	<?php echo wp_trim_words( get_the_excerpt(), 15); ?></p>
												</div>
											</div>
										</a>
									</div>
								</div>
							<?php endwhile;
							wp_reset_query(); ?>
						</div>
					</div>

				</section>

				<!--				<div class="aside-adv">-->
				<!--					--><?php //the_field('section-aside-adv','options'); ?>
				<!--				</div>-->
				<br>
				<section class="news-sections" style="padding-top:0;">
					<div class="box-section">
						<div class="box-section-title">
							<h1>الأكثر مشاهدة</h1>
						</div>

					</div>

					<div class="rest-of-news" style="background: #fff;padding: 10px;margin-top: -20px;">

						<?php $box4 = new WP_Query( array(
							'post_type'      => 'post',
							'posts_per_page' => 10,
							'meta_key'       => 'views',
							'orderby'        => 'meta_value_num',
							'order'          => 'DESC'
						) ); ?>
						<div class="row">
							<?php while ( $box4->have_posts() ) :
								$box4->the_post(); ?>
								<div class="col-sm-12">
									<div class="single-rest">
										<a href="<?php the_permalink(); ?>">
											<div class="row">
												<div class="col-xs-3">
													<?php if ( get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ) ): ?>
														<?php echo get_the_post_thumbnail( $post->id, 'full', array( 'class' => 'img-responsive' ) ); ?>
													<?php else : ?>
														<img src="<?php echo IMAGES; ?>/no-img.png"
														     alt="<?php the_title(); ?>"
														     class="img-responsive">
													<?php endif; ?>
												</div>
												<div class="col-xs-9">
													<h5><?php echo wp_trim_words(get_the_title(),6) ?></h5>
													<p>	<?php echo wp_trim_words( get_the_excerpt(), 15); ?></p>

												</div>
											</div>
										</a>
									</div>
								</div>
							<?php endwhile;
							wp_reset_query(); ?>
						</div>
					</div>

				</section>


			</div>
		</div>
	</div>

</div>
<br><br><br><br>
<section class="socialmedia">
	<div class="container">
		<ul class="list-inline text-center">
			<?php if ( get_field( 'fb', 'options' ) ) : ?>
				<li><a href="<?php the_field( 'fb', 'options' ); ?>"><i class="fa fa-facebook"></i></a></li>
			<?php endif; ?>
			<?php if ( get_field( 'tw', 'options' ) ) : ?>
				<li><a href="<?php the_field( 'tw', 'options' ); ?>"><i class="fa fa-twitter"></i></a></li>
			<?php endif; ?>
			<?php if ( get_field( 'yt', 'options' ) ) : ?>
				<li><a href="<?php the_field( 'yt', 'options' ); ?>"><i class="fa fa-youtube"></i></a></li>
			<?php endif; ?>
			<?php if ( get_field( 'gp', 'options' ) ) : ?>
				<li><a href="<?php the_field( 'gp', 'options' ); ?>"><i class="fa fa-google-plus"></i></a></li>
			<?php endif; ?>
			<?php if ( get_field( 'insta', 'options' ) ) : ?>
				<li><a href="<?php the_field( 'insta', 'options' ); ?>"><i class="fa fa-instagram"></i></a></li>
			<?php endif; ?>
		</ul>
	</div>
</section>
<?php get_footer(); ?>


