<?php get_header();
wp_reset_query(); ?>
<div class="single-page-hd">

	<div class="container">
		<h2 class="page-title"><?php single_cat_title(); ?></h2>
	</div>
</div>

<section class="shop">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ) : the_post(); ?>
				<div class="col-md-3">
					<div class="single-item">
						<div class="item-img">
							<?php echo get_the_post_thumbnail( $post->ID, 'gallery-img-size', array( 'class' => 'img-responsive' ) ); ?>
						</div>
						<div class="item-info">
							<p><?php the_title(); ?></p>
							<span><?php comments_number(); ?></span>
						</div>

						<div class="section-rating">
							<span><?php single_cat_title() ?></span>
							<div class="rating">
								<?php if ( function_exists( 'the_ratings' ) ) {
									the_ratings();
								} ?>
							</div>

						</div>
						<div class="clearfix"></div>
						<div class="btns">
							<a href="<?php the_permalink(); ?>"
							   class="btn btn-blue details"><?php _e( 'تفاصيل المنتج', 'alpha' ); ?></a>
							<a href="<?php echo home_url(); ?>/اتصل-بنا/" class="btn btn-green buy"><?php _e( 'اتصل بنا للشراء', 'alpha' ); ?></a>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
	</div>
</section>


<?php get_footer(); ?>
