<?php get_header();
wp_reset_query(); ?>


<div class="header-section">

    <div id="main-slider" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <h3 class="header-title text-center">
                <?php the_field('header-txt', 'options') ?> <span class="animate-typing" data-animate-loop="true" data-type-delay="300" data-cursor-speed="700"><?php the_field('header-text-typing', 'options') ?></span></h3>
            <form class="d-flex justify-content-center" method="get" role="search" action="<?php echo home_url(); ?>">
                <div class="form-inline">
                    <input type="text" class="form-control" id="s" name="s" placeholder="<?php _e('What are you looking for ?', 'alpha') ?>">
                    <input type="submit" class="btn btn-primary search" value="<?php _e('Search', 'alpha') ?>">
                </div>
            </form>
            <div class="overlay"></div>
            <?php while (have_rows('slider', 'options')) : the_row() ?>
                <div class="carousel-item">
                    <img src="<?php the_sub_field('slider-img') ?>" class="img-fluid" alt="">
                </div>
            <?php endwhile ?>

        </div>
    </div>


</div>
<div class="products-page">
    <div class="our-products" id="our-products">
        <div class="container">
            <p class="kitchens-title text-center fancy-title"><<?php the_archive_title() ?></>
            <div class="btn-filters row d-flex justify-content-center">
                <?php $sections = get_terms(array(
                    'taxonomy' => 'sections',
                    'hide_empty' => false,
                ));
                foreach ($sections as $section) : ?>
                    <button class="tablink" onclick="openPage('<?php echo $section->term_id ?>', this, 'rgba(199, 129, 76, 0.25)')"><?php echo $section->name ?></button>
                <?php endforeach ?>
            </div>

            <?php foreach ($sections as $section) : ?>
                <div id="<?php echo $section->term_id ?>" class="tabcontent">
                    <div class="row">
                        <?php
                        global $paged;
                        if (get_query_var('paged')) {
                            $my_page = get_query_var('paged');
                        } else {
                            if (get_query_var('page')) {
                                $my_page = get_query_var('page');
                            } else {
                                $my_page = 1;
                            }
                            set_query_var('paged', $my_page);
                            $paged = $my_page;
                        }; ?>
                        <?php $products = new WP_Query(array(
                            'post_type'      => 'products',
                            'posts_per_page' => 20,
                            'paged' => $my_page,
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'sections',
                                    'field'    => 'term_id',
                                    'terms'    => $section->term_id,
                                )
                            )
                        ));
                        while ($products->have_posts()) : $products->the_post(); ?>
                            <div class="col-6 col-md-4 col-xl-3">
                                <div class="kitch" id="">
                                    <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>
                                    <?php $imgholder = IMAGES . '/no-img.jpg' ?>
                                    <a href="<?php the_permalink() ?>">
                                        <img class="img-fluid" src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" loading="lazy">
                                    </a>

                                    <p><?php the_title() ?></p>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_query(); ?>

                    </div>

                </div>
            <?php endforeach ?>



            <div class="text-center my-5">
                <?php wp_pagenavi(array('query' => $products)); ?>
            </div>

        </div>
    </div>


</div>

<div class="contact-us">
    <div class="container">
        <div class="contact-title text-center fancy-title "><?php the_field('contact-section-title', 'options') ?></div>
        <p class="contact-p text-center"><?php the_field('contact-txt', 'options') ?></p>
        <div class="form-wrapper">
            <div class="d-flex justify-content-center">
                <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form 1"]') ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>