<?php

/**
 * functions.php
 *
 * The theme's functions and definitions.
 */


/**
 * ----------------------------------------------------------------------------------------
 * 1.0 - Define constants.
 * ----------------------------------------------------------------------------------------
 */

define('THEMEROOT', get_stylesheet_directory_uri());

define('IMAGES', THEMEROOT . '/images');

define('SCRIPTS', THEMEROOT . '/js');

require_once('latest_widget.php');

/**
 * Register Custom Navigation Walker
 */
function register_navwalker()
{
	require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';
}
add_action('after_setup_theme', 'register_navwalker');

add_filter('acf/settings/show_admin', '__return_false');

/**
 * ----------------------------------------------------------------------------------------
 * 4.0 - Set up theme default and register various supported features.
 * ----------------------------------------------------------------------------------------
 */


if (!function_exists('alpha_setup')) {

	function alpha_setup()
	{

		/**
		 * Make the theme available for translation.
		 */

		$lang_dir = THEMEROOT . '/languages';

		load_theme_textdomain('alpha', $lang_dir);


		/**
		 * Add support for post formats.
		 */

		//		add_theme_support( 'post-formats',

		//			array(

		//				'gallery',

		//				'link',

		//				'image',

		//				'quote',

		//				'video',

		//				'audio'

		//			)

		//		);


		/**
		 * Add support for automatic feed links.
		 */

		add_theme_support('automatic-feed-links');

		add_theme_support('widgets');


		/**
		 * Add support for post thumbnails.
		 */

		add_theme_support('post-thumbnails');


		/**
		 * Register nav menus.
		 */

		register_nav_menus(

			array(

				'main' => __('القائمة الرئيسية', 'alpha'),

				'footer1' => __('1قائمة الفوتر ', 'alpha'),
				'footer2' => __('2قائمة الفوتر ', 'alpha'),
				'footer3' => __('3قائمة الفوتر ', 'alpha'),

				//				'footer2' => __( 'قائمة الفوتر2 ', 'alpha' )


			)

		);
	}


	add_action('after_setup_theme', 'alpha_setup');
}


/**
 * ----------------------------------------------------------------------------------------
 * 10.0 - Load the custom scripts for the theme.
 * ----------------------------------------------------------------------------------------
 */




if (!function_exists('alpha_scripts')) {

	function alpha_scripts()
	{

		// Adds support for pages with threaded comments

		if (is_singular() && comments_open() && get_option('thread_comments')) {

			wp_enqueue_script('comment-reply');
		}


		// Register scripts



		wp_register_script('bootstrap-js', SCRIPTS . '/bootstrap.min.js', array('jquery'), false, true);
		wp_enqueue_script('bootstrap-js');

		wp_register_script('popper-js', SCRIPTS . '/popper.min.js.js', array('jquery'), false, true);
		wp_enqueue_script('popper-js');


		wp_register_script('carousel-js', SCRIPTS . '/owl.carousel.min.js', array('jquery'), false, true);
		wp_enqueue_script('carousel-js');

		wp_register_script('animate-js', SCRIPTS . '/animate.js', array('jquery'), false, true);
		wp_enqueue_script('animate-js');

		wp_register_script('wow-js', SCRIPTS . '/wow.min.js', array('jquery'), false, true);
		wp_enqueue_script('wow-js');

		wp_register_script('lettering-js', SCRIPTS . '/jquery.lettering-0.6.1.min.js', array('jquery'), false, true);
		wp_enqueue_script('lettering-js');

		wp_register_script('fancybox-js',  '//cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.js', array('jquery'), false, true);
		wp_enqueue_script('fancybox-js');

		wp_register_script('animateTyping-js', SCRIPTS . '/jquery.animateTyping.js', array('jquery'), false, true);
		wp_enqueue_script('animateTyping-js');

		wp_register_script('custom-js', SCRIPTS . '/index.js', array('jquery'), false, true);

		wp_enqueue_script('custom-js');

		// wp_localize_script(
		// 	'custom-js',
		// 	'my_ajax_object',
		// 	array('ajax_url' => admin_url('admin-ajax.php'))
		// );

		// Load the stylesheets

		// wp_enqueue_style('hover', THEMEROOT . '/css/hover.css');
		wp_enqueue_style('animate.min', THEMEROOT . '/css/animate.min.css');
		wp_enqueue_style('fancybox',  'https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css');
		wp_enqueue_style('fontawesome', 'https://use.fontawesome.com/releases/v5.14.0/css/all.css');
		// wp_enqueue_style( 'reset', THEMEROOT . '/css/reset.min.css' );
		// wp_enqueue_style( 'normalize', THEMEROOT . '/css/normalize.css' );
		// wp_enqueue_style('carousel', THEMEROOT . '/css/owl.carousel.min.css');
		// wp_enqueue_style('owl.theme.default', THEMEROOT . '/css/owl.theme.default.min.css');



		if (is_rtl()) {


			wp_enqueue_style('bootstrap-rtl', THEMEROOT . '/css/bootstrap-rtl.min.css');

			wp_enqueue_style('rtl', THEMEROOT . '/css/rtl.css');
		} else {
			wp_enqueue_style('bootstrap', THEMEROOT . '/css/bootstrap.min.css');

			wp_enqueue_style('en', THEMEROOT . '/css/style.css');
		}
	}


	add_action('wp_enqueue_scripts', 'alpha_scripts');
}


/**
 * ----------------------------------------------------------------------------------------
 * 11.0 - Custom Post Type.
 * ----------------------------------------------------------------------------------------
 */

register_post_type('products', array(

	'public' => true,

	'hierarchical' => false,

	'exclude_from_search' => false,

	'has_archive' => true,

	'rewrite' => array('slug' => 'products'),

	'capability_type' => 'post',

	'menu_icon' => 'dashicons-layout',

	'taxonomies' => array('post_tag'),

	'labels' => array(

		'name' => __('Products', 'alpha'),

		'singular_name' => __('Product', 'alpha'),

		'menu_name' => __('Products', 'alpha'),

		'name_admin_bar' => __('Products', 'alpha'),

		'new_item' => __('New Product', 'alpha'),


	),

	'supports' => array('title', 'editor', 'thumbnail', 'comments')

));



/*************************************************/
/* Register Taxonami */
/*************************************************/
add_action('init', 'create_sections');

function create_sections()
{
	register_taxonomy(
		'sections',
		'products',
		array(
			'label'             => __('Products Sections', 'alpha'),
			'hierarchical'      => true,
			'show_ui'           => true,
			'show_admin_column' => true,
			'show_in_nav_menus' => true,
			'show_tagcloud'     => true,
			'public'            => true
		)

	);
}

add_image_size('small', 100, 100);


/*************************************************/

/* Page Option */

/*************************************************/

if (function_exists('acf_add_options_page')) {


	acf_add_options_page(array(

		'page_title' => __('Theme Options', 'alpha'),

		'menu_title' => __('Theme Options', 'alpha'),

		'menu_slug' => 'theme-general-settings',

		'capability'	=> 'activate_plugins',


		'update_button' => __('Save', 'alpha'),

		'redirect' => false

	));
}



function mytheme_admin_bar_render()
{
	if (current_user_can('delete_pages')) {
		global $wp_admin_bar;

		$wp_admin_bar->add_menu(array(

			'id' => 'themeoptions',


			'title' => ' &#12245; ' . __('Theme Options', 'alpha'),

			'href' => admin_url('admin.php?page=theme-general-settings'),

			'icon' => 'img'

		));
	}
}




// and we hook our function via

add_action('wp_before_admin_bar_render', 'mytheme_admin_bar_render');


/*************************************************/

/* Sidebar */

/*************************************************/

if (function_exists('register_sidebar')) {

	register_sidebar(

		array(

			'name' => 'sidebar',

			'id' => 'sidebar',

			'description' => 'Sidebar',

			'before_widget' => '<div class="rest-of-news">',

			'after_widget' => '</div>',

			'before_title' => '<h1 class="box-section-title">',

			'after_title' => '</h1>'


		)

	);
}





// Update CSS within in Admin
// function admin_style()
// {
// 	wp_enqueue_style('admin-styles', get_template_directory_uri() . '/admin.css');
// }
// add_action('admin_enqueue_scripts', 'admin_style');




// remove admin bar items by roles
function remove_from_admin_bar($wp_admin_bar)
{
	/*
     * Placing items in here will only remove them from admin bar
     * when viewing the fronte end of the site
    */
	if (!is_super_admin()) {

		// WordPress Core Items (uncomment to remove)
		$wp_admin_bar->remove_node('updates');
		$wp_admin_bar->remove_node('comments');
		$wp_admin_bar->remove_node('new-content');
		$wp_admin_bar->remove_node('wp-logo');
		// $wp_admin_bar->remove_node('site-name');
		$wp_admin_bar->remove_node('my-account');
		$wp_admin_bar->remove_node('search');
		$wp_admin_bar->remove_node('customize');
	}
}
add_action('admin_bar_menu', 'remove_from_admin_bar', 999);



function generateVideoEmbedUrl($url)
{
	//This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$finalUrl = '';
	if (strpos($url, 'facebook.com/') !== false) {
		//it is FB video
		$finalUrl .= 'https://www.facebook.com/plugins/video.php?href=' . rawurlencode($url) . '&show_text=1&width=200';
	} else if (strpos($url, 'vimeo.com/') !== false) {
		//it is Vimeo video
		$videoId = explode("vimeo.com/", $url)[1];
		if (strpos($videoId, '&') !== false) {
			$videoId = explode("&", $videoId)[0];
		}
		$finalUrl .= 'https://player.vimeo.com/video/' . $videoId;
	} else if (strpos($url, 'youtube.com/') !== false) {
		//it is Youtube video
		$videoId = explode("v=", $url)[1];
		if (strpos($videoId, '&') !== false) {
			$videoId = explode("&", $videoId)[0];
		}
		$finalUrl .= 'https://www.youtube.com/embed/' . $videoId;
	} else if (strpos($url, 'youtu.be/') !== false) {
		//it is Youtube video
		$videoId = explode("youtu.be/", $url)[1];
		if (strpos($videoId, '&') !== false) {
			$videoId = explode("&", $videoId)[0];
		}
		$finalUrl .= 'https://www.youtube.com/embed/' . $videoId;
	} else {
		//Enter valid video URL
	}
	return $finalUrl;
}
