<!DOCTYPE html>

<!--[if IE 8]>

<html <?php language_attributes(); ?> class="ie8"> <![endif]-->

<!--[if !IE]><!-->

<html <?php language_attributes(); ?>>
<!--<![endif]-->



<head>

    <meta charset="<?php bloginfo('charset'); ?>">

    <title><?php wp_title('|', true, 'right'); ?><?php bloginfo('name'); ?></title>

    <meta name="description" content="<?php bloginfo('description'); ?>">

    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">

    <!-- Mobile Specific Meta -->

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">



    <!--[if lt IE 9]>

    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>

    <![endif]-->





    <?php wp_head(); ?>



</head>



<body <?php body_class(); ?>>




    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">

            <a class="navbar-brand" href="<?php echo home_url() ?>"><img src="<?php the_field('logo', 'options') ?>" alt="<?php bloginfo('name') ?>"></a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mainnav" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="mainnav">
                <?php

                wp_nav_menu(array(

                    'menu'            => 'main',

                    'theme_location'  => 'main',

                    'depth'           => 2,

                    'container'       => '',

                    // 'container_class' => 'collapse navbar-collapse',

                    // 'container_id'    => 'bs-example-navbar-collapse-1',

                    'menu_class'      => 'navbar-nav',

                    'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
                    'walker'          => new WP_Bootstrap_Navwalker(),

                ));

                ?>

                <ul class="navbar-nav catalog-ul ">
                    <li class="nav-item dropdown catalogs">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php _e('Catalog','alpha') ?>
                        </a>
                        <div class="dropdown-menu drop-2 text-center" aria-labelledby="navbarDropdown">

                            <?php while (have_rows('catalog', 'options')) : the_row() ?>
                                <div class="dropdown-item" href="">
                                    <span><?php the_sub_field('catalog-title') ?></span>
                                    <a href="<?php the_sub_field('catalog-view') ?>"><img src="<?php echo IMAGES ?>/show-icon.svg" alt="View catalog"></a>
                                    <a href="<?php the_sub_field('catalog-down') ?>"><img src="<?php echo IMAGES ?>/download-icon.svg" alt="Download catalog"></a>
                                </div>
                            <?php endwhile ?>

                        </div>
                    </li>

                </ul>

            </div>
        </div>
    </nav>