<?php get_header(); ?>

<div class="header-section">

    <div id="main-slider" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <h3 class="header-title text-center">
                <?php the_field('header-txt', 'options') ?> <span class="animate-typing" data-animate-loop="true" data-type-delay="300" data-cursor-speed="700"><?php the_field('header-text-typing', 'options') ?></span></h3>
            <form class="d-flex justify-content-center" method="get" role="search" action="<?php echo home_url(); ?>">
                <div class="form-inline">
                    <input type="text" class="form-control" id="s" name="s" placeholder="<?php _e('What are you looking for ?', 'alpha') ?>">
                    <input type="submit" class="btn btn-primary search" value="<?php _e('Search', 'alpha') ?>">
                </div>
            </form>
            <div class="overlay"></div>
            <?php while (have_rows('slider', 'options')) : the_row() ?>
                <div class="carousel-item">
                    <img src="<?php the_sub_field('slider-img') ?>" class="img-fluid" alt="">
                </div>
            <?php endwhile ?>

        </div>
    </div>


</div>


<div class="features">
    <div class="container">
        <p class="features-title text-center fancy-title"><?php the_field('feature-section-title', 'options') ?></p>
        <div class="row">
            <?php while (have_rows('features', 'options')) : the_row() ?>
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="card text-center">
                        <div class="card-img-top">
                            <img src="<?php the_sub_field('icon') ?>" alt="<?php the_sub_field('title') ?>">
                        </div>
                        <p class="card-title"><?php the_sub_field('title') ?></p>
                        <p class="card-text"><?php the_sub_field('description') ?></p>
                    </div>
                </div>
            <?php endwhile ?>

        </div>
    </div>
</div>
<div class="our-kitchens">
    <div class="container">
        <p class="kitchens-title text-center fancy-title"><?php the_field('gallery-section-title', 'options') ?></p>
        <div class="row">
            <?php $gallery = get_field('work-gallery', 'options');
            if ($gallery) : ?>
                <?php $i = 0;
                foreach ($gallery as $img) : ?>
                    <?php if ($i > 7) : break;
                    endif; ?>

                    <div class="col-6 col-md-4 col-xl-3">
                        <div class="kitch">
                            <a href="<?php echo $img['url'] ?>" data-fancybox="gallery"> <img src="<?php echo $img['sizes']['medium'] ?>" loading="lazy" class="img-fluid" alt=""></a>
                        </div>
                    </div>
                <?php $i++;
                endforeach;
                ?>
            <?php endif; ?>

        </div>
    </div>
</div>


<div class="our-products">
    <div class="container">
        <p class="kitchens-title text-center fancy-title"><?php the_field('products-section-title', 'options') ?></p>
        <div class="btn-filters row d-flex justify-content-center">
            <?php $sections = get_field('products-sections', 'options');
            if ($sections) :
                foreach ($sections as $section) : ?>
                    <button class="tablink" onclick="openPage('<?php echo $section->term_id ?>', this, 'rgba(199, 129, 76, 0.25)')"><?php echo $section->name ?></button>
            <?php endforeach;
            endif; ?>
        </div>

        <?php
        if ($sections) :
            foreach ($sections as $section) : ?>
                <div id="<?php echo $section->term_id ?>" class="tabcontent">
                    <div class="row">

                        <?php $products = new WP_Query(array(
                            'post_type'      => 'products',
                            'posts_per_page' => get_field('products-post-count', 'options'),
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'sections',
                                    'field'    => 'term_id',
                                    'terms'    => $section->term_id,
                                )
                            )
                        ));
                        while ($products->have_posts()) : $products->the_post(); ?>
                            <div class="col-6 col-md-4 col-xl-3">
                                <div class="kitch" id="">
                                    <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>
                                    <?php $imgholder = IMAGES . '/no-img.jpg' ?>
                                    <a href="<?php the_permalink() ?>">
                                        <img class="img-fluid" src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" loading="lazy">
                                    </a>

                                    <p><?php the_title() ?></p>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_query(); ?>

                    </div>

                </div>
        <?php endforeach;
        endif; ?>




    </div>
</div>

<!--start latest news-->
<div class="latest-news">
    <div class="container">
        <div class="news-title text-center"><?php the_field('news-section-title', 'options') ?></div>
        <div class="row">
            <?php $news = new WP_Query(array(
                'post_type'      => 'post',
                'posts_per_page' => get_field('news-count', 'options'),

            ));
            while ($news->have_posts()) : $news->the_post(); ?>
                <div class="col-12 col-md-6">
                    <a href="<?php the_permalink() ?>">
                        <div class="blog-article">
                            <div class="overlay"></div>
                            <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>
                            <?php $imgholder = IMAGES . '/no-img.jpg' ?>
                            <img class="img-fluid" src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" loading="lazy">

                            <p class="article-p"><?php the_title() ?></p>
                        </div>
                    </a>
                </div>
            <?php endwhile;
            wp_reset_query(); ?>

        </div>
    </div>
</div>


<div class="kitchen-video">
    <div class="container">
        <div class="promotion-video">
            <a data-toggle="modal" data-target="#exampleModal" href="#">
                <img src="<?php the_field('video-bg', 'options') ?>" alt="Promotion video poster" class="img-fluid">
                <i class="fa fa-play" aria-hidden="true"></i>
            </a>
        </div>
        <?php $url = get_field('video-url', 'options');
        if ($url) : ?>
            <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none; padding-right: 17px;" aria-modal="true" role="dialog">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body  p-0">

                            <div class="embed-responsive embed-responsive-16by9">
                                <iframe class="embed-responsive-item" width="560" height="315" src="<?php echo  generateVideoEmbedUrl($url) ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe>

                            </div>


                        </div>

                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="contact-us">
    <div class="container">
        <div class="contact-title text-center fancy-title "><?php the_field('contact-section-title', 'options') ?></div>
        <p class="contact-p text-center"><?php the_field('contact-txt', 'options') ?></p>
        <div class="form-wrapper">
            <div class="d-flex justify-content-center">
                <?php
                if (is_rtl()) {

                    echo "<div dir='rtl'>" . do_shortcode('[contact-form-7 id="293" title="اتصل بنا steps"]') . "</div>";
                } else {
                    echo do_shortcode('[contact-form-7 id="5" title="Contact form 1"]');
                } ?>

            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>