<?php
/***********************************************************************************************/
/* Widget that displays a single 260x120 ad block */

/***********************************************************************************************/

class latest_Widget extends WP_Widget
{

    public function __construct()
    {
        parent::__construct(
            'latest',
            'آخر المقالات',
            array(
                'description' => __('تعرض اخر المقالات حسب Post Type')
            )
        );
    }

    public function form($instance)
    {
        $instance = wp_parse_args((array)$instance);

        ?>
        <!-- The Title -->
        <p>
            <label for="<?php echo $this->get_field_id('title') ?>"><?php _e('العنوان:'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>"
                   value="<?php echo esc_attr($instance['title']); ?>"/>
        </p>

        <?php

    }

    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        // The Title
        $instance['title'] = strip_tags($new_instance['title']);

        return $instance;
    }

    public function widget($args, $instance)
    {
        extract($args);

        // Get the title and prepare it for display
        $title = apply_filters('widget_title', $instance['title']);

        ?>

        <div class="rest-of-news">
            <div class="box-section-title">
                <h6><?php if ($title) {
                        echo $title;
                    } ?>
                </h6>
            </div>
            <div class="readers-articles-list">
                <?php

                $articles = new WP_Query(array(
                    'post_type' => get_post_type(get_the_ID()),
                    'posts_per_page' => 10,
                    'post__not_in' => array(get_the_ID())
                )); ?>
                <?php if ($articles->have_posts()) : while ($articles->have_posts()) : $articles->the_post(); ?>
                    <div class="single-article d-flex">
                        <div class="article-img">
                            <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), array(60, 60)); ?>
                            <?php $imgholder = IMAGES . '/no-img.jpg' ?>
                            <a href="<?php the_permalink() ?>"><img class="img-fluid img-thumbnail"
                                                                    src="<?php echo $thumb ? $thumb : $imgholder ?>"
                                                                    alt="<?php the_title() ?>"></a>
                        </div>

                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                        <!--                        <p>-->
                        <?php //$txt = mb_substr(get_the_excerpt('', '', FALSE), 0, 170, "utf-8") . ' ...';
                        //                            echo strip_tags($txt); ?><!--</p>-->

                        <!--                        <h3><a href="--><?php //the_permalink(); ?><!--">-->
                        <?php //_e('اقرأ المزيد', 'alpha') ?><!--</a></h3>-->
                        <div class="clearfix"></div>
                    </div>
                <?php endwhile; endif;
                wp_reset_query(); ?>
            </div>
        </div>

        <?php
    }
}

register_widget('latest_Widget');

?>
