<?php

/* Template name:Blog  */

get_header();
wp_reset_query(); ?>


<div class="header-section">

  <div id="main-slider" class="carousel slide" data-ride="carousel">
    <div class="carousel-inner">

      <div class="overlay"></div>
      <?php while (have_rows('slider', 'options')) : the_row() ?>
        <div class="carousel-item">
          <img src="<?php the_sub_field('slider-img') ?>" class="img-fluid" alt="">
        </div>
      <?php endwhile ?>

    </div>
  </div>


</div>

<div class="white-wrapper-blog">
  <div class="container">
    <div class="row">
      
      <?php $blog = new WP_Query(array(
        'post_type'      => 'post',
        'posts_per_page' => 1,
       

      ));

      $i = 0;
      while ($blog->have_posts()) :  $blog->the_post(); ?>
       
        <div class="w-100">
          <div class="blog-title">
            <div class="overlay"></div>
            <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>
            <?php $imgholder = IMAGES . '/no-img.jpg' ?>

            <img src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" class="img-fluid" loading="lazy">
            <div class="blog-main-title">
              <div class="blog-des"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></div>
              <div class="blog-p"><?php the_excerpt() ?></div>
            </div>
          </div>
        </div>
      <?php $i++;
      endwhile;
      wp_reset_query() ?>

      <div class="blogs p-5 bg-white w-100">

        <div class="row">
          <?php 
           global $paged;
           if (get_query_var('paged')) {
             $my_page = get_query_var('paged');
           } else {
             if (get_query_var('page')) {
               $my_page = get_query_var('page');
             } else {
               $my_page = 1;
             }
             set_query_var('paged', $my_page);
             $paged = $my_page;
           }; ?>
           <?php $blog = new WP_Query(array(
             'post_type'      => 'post',
             'posts_per_page' => 20,
             'offset'=>1,
             'paged' => $my_page
     
           )); ?>
          <?php while ($blog->have_posts()) : $blog->the_post() ?>
            <div class="col-12 col-lg-6">
              <a href="<?php the_permalink() ?>">
                <div class="blog-article">
                  <div class="overlay"></div>
                  <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>
                  <?php $imgholder = IMAGES . '/no-img.jpg' ?>

                  <img src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" class="img-fluid" loading="lazy">
                  <p class="article-p"><?php the_title() ?></p>
                </div>
              </a>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>

        </div>
        <div class="text-center py-4">
          <?php wp_pagenavi(); ?>
        </div>
      </div>
    </div>
  </div>

</div>
<!--start blogs-->

<div class="contact-us">
    <div class="container">
        <div class="contact-title text-center fancy-title "><?php the_field('contact-section-title', 'options') ?></div>
        <p class="contact-p text-center"><?php the_field('contact-txt', 'options') ?></p>
        <div class="form-wrapper">
            <div class="d-flex justify-content-center">
                <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form 1"]') ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>