<?php
	/* Template Name: Contact */; ?>


<?php get_header();
wp_reset_query(); ?>



<div class="map">
	<div class="row">
		<div class="col-12">
			<div class="google-maps">

				<?php the_field('google-map', 'options') ?>
			</div>
		</div>
	</div>
</div>
</div>

<section class="contact-page">
	<div class="container contact" id="container">
		<div class="contact-us">
			<h3 class="contact-title text-center fancy-title"><?php the_title() ?></h3>
			<div class="row">
				<div class="col-12 col-md-6 col-lg-4">
					<div class="card text-center">
						<div class="card-img-top">
							<img src="<?php echo IMAGES ?>/address-icon.svg" alt="">
						</div>
						<p class="card-text"><?php the_field('address', 'options') ?></p>
					</div>
				</div>
				<div class="col-12 col-md-6 col-lg-4">
					<div class="card text-center">
						<div class="card-img-top">
							<img src="<?php echo IMAGES ?>/phone-icon.svg" alt="">
						</div>
						<p class="card-text"><?php the_field('phone', 'options') ?></p>
					</div>
				</div>
				<div class="col-12 col-md-6 col-lg-4">
					<div class="card text-center">
						<div class="card-img-top">
							<img src="<?php echo IMAGES ?>/mail-icon.svg" alt="">
						</div>
						<p class="card-text"><?php the_field('email', 'options') ?></p>
					</div>
				</div>
			</div>
			<p class="form-title text-center"><?php _e('We are carefully listening to you', 'alpha') ?></p>

			<div class="msg-form text-center">

				<div class="col-lg-10 offset-lg-1">
					<?php

					if (is_rtl()) {

						echo do_shortcode('[contact-form-7 id="294" title="اتصل بنا"]');
					} else {

						echo do_shortcode('[contact-form-7 id="126" title="contact form full"]');
					} ?>
				</div>

			</div>
		</div>

	</div>



</section>



<?php get_footer(); ?>