<?php

/* Template name:Kitchens  */

get_header();
wp_reset_query(); ?>


<div class="header-section">

    <div id="main-slider" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <h3 class="header-title text-center">
                <?php the_field('header-txt', 'options') ?> <span class="animate-typing" data-animate-loop="true" data-type-delay="300" data-cursor-speed="700"><?php the_field('header-text-typing', 'options') ?></span></h3>
            <form class="d-flex justify-content-center" method="get" role="search" action="<?php echo home_url(); ?>">
                <div class="form-inline">
                    <input type="text" class="form-control" id="s" name="s" placeholder="<?php _e('What are you looking for ?', 'alpha') ?>">
                    <input type="submit" class="btn btn-primary search" value="<?php _e('Search', 'alpha') ?>">
                </div>
            </form>
            <div class="overlay"></div>
            <?php while (have_rows('slider', 'options')) : the_row() ?>
                <div class="carousel-item">
                    <img src="<?php the_sub_field('slider-img') ?>" class="img-fluid" alt="">
                </div>
            <?php endwhile ?>

        </div>
    </div>


</div>
<div class="kitchens-page">
  <div class="our-kitchens" id="our-kitchens">
    <div class="container">
 
        <p class="kitchens-title text-center fancy-title"><?php the_field('gallery-section-title', 'options') ?></p>
        <div class="row">
            <?php $gallery = get_field('work-gallery', 'options');
            if ($gallery) : ?>
                <?php $i = 0;
                foreach ($gallery as $img) : ?>
                    

                    <div class="col-6 col-md-4 col-xl-3">
                        <div class="kitch wow zoomIn" data-wow-delay="<?php echo $i ?>00ms">
                            <a href="<?php echo $img['url'] ?>" data-fancybox="gallery"> <img src="<?php echo $img['sizes']['medium'] ?>" loading="lazy" class="img-fluid" alt=""></a>
                        </div>
                    </div>
                <?php $i++;
                endforeach;
                ?>
            <?php endif; ?>

        </div>
    
</div>
  </div>

</div>
<!--start blogs-->

<div class="contact-us">
    <div class="container">
        <div class="contact-title text-center fancy-title "><?php the_field('contact-section-title', 'options') ?></div>
        <p class="contact-p text-center"><?php the_field('contact-txt', 'options') ?></p>
        <div class="form-wrapper">
            <div class="d-flex justify-content-center">
                <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form 1"]') ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>