<?php get_header();
wp_reset_query(); ?>
<div class="header-section">

    <div id="main-slider" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">

            <div class="overlay"></div>
            <?php while (have_rows('slider', 'options')) : the_row() ?>
                <div class="carousel-item">
                    <img src="<?php the_sub_field('slider-img') ?>" class="img-fluid" alt="">
                </div>
            <?php endwhile ?>

        </div>
    </div>


</div>

<div class="white-wrapper-blog">
    <div class="container">
        <div class="row">
            <div class="bg-white">
                <div class="article-thumbnail">
                    <?php $thumb = get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>
                    <?php $imgholder = IMAGES . '/no-img.jpg' ?>

                    <img src="<?php echo $thumb ? $thumb : $imgholder ?>" alt="<?php the_title() ?>" class="img-fluid" loading="lazy">
                </div>

                <div class="blogs p-5">

                    <h3 class="blogs-des"><?php the_title() ?></h3>
                    <div class="blogs-p"><?php the_content() ?></div>
                    <div class="gallery">
                        <?php $gallery = get_field('gallery');
                        if($gallery) :
                        foreach ($gallery as $img) : ?>
                            <div class="img-gallery mb-3"><a href="<?php echo $img['url'] ?>" data-fancybox="gallery"><img src="<?php echo $img['sizes']['medium'] ?>" class="img-fluid img-thumbnail shadow-sm" alt="Gallery img" loading="lazy"></a></div>

                        <?php endforeach ; endif?>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="contact-us">
    <div class="container">
        <div class="contact-title text-center fancy-title "><?php the_field('contact-section-title', 'options') ?></div>
        <p class="contact-p text-center"><?php the_field('contact-txt', 'options') ?></p>
        <div class="form-wrapper">
            <div class="d-flex justify-content-center">
                <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form 1"]') ?>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>